/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.command.InputAsync;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.constant.DispatchDragEvent;
import io.webfolder.cdp.type.constant.KeyEventType;
import io.webfolder.cdp.type.constant.MouseEventType;
import io.webfolder.cdp.type.constant.PointerType;
import io.webfolder.cdp.type.constant.TouchEventType;
import io.webfolder.cdp.type.input.DragData;
import io.webfolder.cdp.type.input.GestureSourceType;
import io.webfolder.cdp.type.input.MouseButton;
import io.webfolder.cdp.type.input.TouchPoint;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class InputAsyncImpl
implements InputAsync {
    private static final CommandReturnType CRT_DISPATCH_DRAG_EVENT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DISPATCH_KEY_EVENT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DISPATCH_MOUSE_EVENT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DISPATCH_TOUCH_EVENT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_EMULATE_TOUCH_FROM_MOUSE_EVENT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_IME_SET_COMPOSITION = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_INSERT_TEXT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_IGNORE_INPUT_EVENTS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_INTERCEPT_DRAGS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SYNTHESIZE_PINCH_GESTURE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SYNTHESIZE_SCROLL_GESTURE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SYNTHESIZE_TAP_GESTURE = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] PARAMS_DISPATCH_DRAG_EVENT_1 = new String[]{"type", "x", "y", "data"};
    private static final String[] PARAMS_DISPATCH_DRAG_EVENT_2 = new String[]{"type", "x", "y", "data", "modifiers"};
    private static final String[] PARAMS_DISPATCH_KEY_EVENT_1 = new String[]{"type"};
    private static final String[] PARAMS_DISPATCH_KEY_EVENT_2 = new String[]{"type", "modifiers", "timestamp", "text", "unmodifiedText", "keyIdentifier", "code", "key", "windowsVirtualKeyCode", "nativeVirtualKeyCode", "autoRepeat", "isKeypad", "isSystemKey", "location", "commands"};
    private static final String[] PARAMS_DISPATCH_MOUSE_EVENT_1 = new String[]{"type", "x", "y"};
    private static final String[] PARAMS_DISPATCH_MOUSE_EVENT_2 = new String[]{"type", "x", "y", "modifiers", "timestamp", "button", "buttons", "clickCount", "force", "tangentialPressure", "tiltX", "tiltY", "twist", "deltaX", "deltaY", "pointerType"};
    private static final String[] PARAMS_DISPATCH_TOUCH_EVENT_1 = new String[]{"type", "touchPoints"};
    private static final String[] PARAMS_DISPATCH_TOUCH_EVENT_2 = new String[]{"type", "touchPoints", "modifiers", "timestamp"};
    private static final String[] PARAMS_EMULATE_TOUCH_FROM_MOUSE_EVENT_1 = new String[]{"type", "x", "y", "button"};
    private static final String[] PARAMS_EMULATE_TOUCH_FROM_MOUSE_EVENT_2 = new String[]{"type", "x", "y", "button", "timestamp", "deltaX", "deltaY", "modifiers", "clickCount"};
    private static final String[] PARAMS_IME_SET_COMPOSITION_1 = new String[]{"text", "selectionStart", "selectionEnd"};
    private static final String[] PARAMS_IME_SET_COMPOSITION_2 = new String[]{"text", "selectionStart", "selectionEnd", "replacementStart", "replacementEnd"};
    private static final String[] PARAMS_INSERT_TEXT_1 = new String[]{"text"};
    private static final String[] PARAMS_SET_IGNORE_INPUT_EVENTS_1 = new String[]{"ignore"};
    private static final String[] PARAMS_SET_INTERCEPT_DRAGS_1 = new String[]{"enabled"};
    private static final String[] PARAMS_SYNTHESIZE_PINCH_GESTURE_1 = new String[]{"x", "y", "scaleFactor"};
    private static final String[] PARAMS_SYNTHESIZE_PINCH_GESTURE_2 = new String[]{"x", "y", "scaleFactor", "relativeSpeed", "gestureSourceType"};
    private static final String[] PARAMS_SYNTHESIZE_SCROLL_GESTURE_1 = new String[]{"x", "y"};
    private static final String[] PARAMS_SYNTHESIZE_SCROLL_GESTURE_2 = new String[]{"x", "y", "xDistance", "yDistance", "xOverscroll", "yOverscroll", "preventFling", "speed", "gestureSourceType", "repeatCount", "repeatDelayMs", "interactionMarkerName"};
    private static final String[] PARAMS_SYNTHESIZE_TAP_GESTURE_1 = new String[]{"x", "y"};
    private static final String[] PARAMS_SYNTHESIZE_TAP_GESTURE_2 = new String[]{"x", "y", "duration", "tapCount", "gestureSourceType"};
    private final SessionInvocationHandler handler;

    public InputAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<Void> dispatchDragEvent(DispatchDragEvent type, Double x, Double y, DragData data) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_dispatchDragEvent, CRT_DISPATCH_DRAG_EVENT, PARAMS_DISPATCH_DRAG_EVENT_1, new Object[]{type, x, y, data}, false);
    }

    @Override
    public CompletableFuture<Void> dispatchDragEvent(DispatchDragEvent type, Double x, Double y, DragData data, Integer modifiers) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_dispatchDragEvent, CRT_DISPATCH_DRAG_EVENT, PARAMS_DISPATCH_DRAG_EVENT_2, new Object[]{type, x, y, data, modifiers}, false);
    }

    @Override
    public CompletableFuture<Void> dispatchKeyEvent(KeyEventType type) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_dispatchKeyEvent, CRT_DISPATCH_KEY_EVENT, PARAMS_DISPATCH_KEY_EVENT_1, new Object[]{type}, false);
    }

    @Override
    public CompletableFuture<Void> dispatchKeyEvent(KeyEventType type, Integer modifiers, Double timestamp, String text, String unmodifiedText, String keyIdentifier, String code, String key, Integer windowsVirtualKeyCode, Integer nativeVirtualKeyCode, Boolean autoRepeat, Boolean isKeypad, Boolean isSystemKey, Integer location, List<String> commands) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_dispatchKeyEvent, CRT_DISPATCH_KEY_EVENT, PARAMS_DISPATCH_KEY_EVENT_2, new Object[]{type, modifiers, timestamp, text, unmodifiedText, keyIdentifier, code, key, windowsVirtualKeyCode, nativeVirtualKeyCode, autoRepeat, isKeypad, isSystemKey, location, commands}, false);
    }

    @Override
    public CompletableFuture<Void> dispatchMouseEvent(MouseEventType type, Double x, Double y) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_dispatchMouseEvent, CRT_DISPATCH_MOUSE_EVENT, PARAMS_DISPATCH_MOUSE_EVENT_1, new Object[]{type, x, y}, false);
    }

    @Override
    public CompletableFuture<Void> dispatchMouseEvent(MouseEventType type, Double x, Double y, Integer modifiers, Double timestamp, MouseButton button, Integer buttons, Integer clickCount, Double force, Double tangentialPressure, Integer tiltX, Integer tiltY, Integer twist, Double deltaX, Double deltaY, PointerType pointerType) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_dispatchMouseEvent, CRT_DISPATCH_MOUSE_EVENT, PARAMS_DISPATCH_MOUSE_EVENT_2, new Object[]{type, x, y, modifiers, timestamp, button, buttons, clickCount, force, tangentialPressure, tiltX, tiltY, twist, deltaX, deltaY, pointerType}, false);
    }

    @Override
    public CompletableFuture<Void> dispatchTouchEvent(TouchEventType type, List<TouchPoint> touchPoints) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_dispatchTouchEvent, CRT_DISPATCH_TOUCH_EVENT, PARAMS_DISPATCH_TOUCH_EVENT_1, new Object[]{type, touchPoints}, false);
    }

    @Override
    public CompletableFuture<Void> dispatchTouchEvent(TouchEventType type, List<TouchPoint> touchPoints, Integer modifiers, Double timestamp) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_dispatchTouchEvent, CRT_DISPATCH_TOUCH_EVENT, PARAMS_DISPATCH_TOUCH_EVENT_2, new Object[]{type, touchPoints, modifiers, timestamp}, false);
    }

    @Override
    public CompletableFuture<Void> emulateTouchFromMouseEvent(MouseEventType type, Integer x, Integer y, MouseButton button) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_emulateTouchFromMouseEvent, CRT_EMULATE_TOUCH_FROM_MOUSE_EVENT, PARAMS_EMULATE_TOUCH_FROM_MOUSE_EVENT_1, new Object[]{type, x, y, button}, false);
    }

    @Override
    public CompletableFuture<Void> emulateTouchFromMouseEvent(MouseEventType type, Integer x, Integer y, MouseButton button, Double timestamp, Double deltaX, Double deltaY, Integer modifiers, Integer clickCount) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_emulateTouchFromMouseEvent, CRT_EMULATE_TOUCH_FROM_MOUSE_EVENT, PARAMS_EMULATE_TOUCH_FROM_MOUSE_EVENT_2, new Object[]{type, x, y, button, timestamp, deltaX, deltaY, modifiers, clickCount}, false);
    }

    @Override
    public CompletableFuture<Void> imeSetComposition(String text, Integer selectionStart, Integer selectionEnd) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_imeSetComposition, CRT_IME_SET_COMPOSITION, PARAMS_IME_SET_COMPOSITION_1, new Object[]{text, selectionStart, selectionEnd}, false);
    }

    @Override
    public CompletableFuture<Void> imeSetComposition(String text, Integer selectionStart, Integer selectionEnd, Integer replacementStart, Integer replacementEnd) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_imeSetComposition, CRT_IME_SET_COMPOSITION, PARAMS_IME_SET_COMPOSITION_2, new Object[]{text, selectionStart, selectionEnd, replacementStart, replacementEnd}, false);
    }

    @Override
    public CompletableFuture<Void> insertText(String text) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_insertText, CRT_INSERT_TEXT, PARAMS_INSERT_TEXT_1, new Object[]{text}, false);
    }

    @Override
    public CompletableFuture<Void> setIgnoreInputEvents(Boolean ignore) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_setIgnoreInputEvents, CRT_SET_IGNORE_INPUT_EVENTS, PARAMS_SET_IGNORE_INPUT_EVENTS_1, new Object[]{ignore}, false);
    }

    @Override
    public CompletableFuture<Void> setInterceptDrags(Boolean enabled) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_setInterceptDrags, CRT_SET_INTERCEPT_DRAGS, PARAMS_SET_INTERCEPT_DRAGS_1, new Object[]{enabled}, false);
    }

    @Override
    public CompletableFuture<Void> synthesizePinchGesture(Double x, Double y, Double scaleFactor) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_synthesizePinchGesture, CRT_SYNTHESIZE_PINCH_GESTURE, PARAMS_SYNTHESIZE_PINCH_GESTURE_1, new Object[]{x, y, scaleFactor}, false);
    }

    @Override
    public CompletableFuture<Void> synthesizePinchGesture(Double x, Double y, Double scaleFactor, Integer relativeSpeed, GestureSourceType gestureSourceType) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_synthesizePinchGesture, CRT_SYNTHESIZE_PINCH_GESTURE, PARAMS_SYNTHESIZE_PINCH_GESTURE_2, new Object[]{x, y, scaleFactor, relativeSpeed, gestureSourceType}, false);
    }

    @Override
    public CompletableFuture<Void> synthesizeScrollGesture(Double x, Double y) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_synthesizeScrollGesture, CRT_SYNTHESIZE_SCROLL_GESTURE, PARAMS_SYNTHESIZE_SCROLL_GESTURE_1, new Object[]{x, y}, false);
    }

    @Override
    public CompletableFuture<Void> synthesizeScrollGesture(Double x, Double y, Double xDistance, Double yDistance, Double xOverscroll, Double yOverscroll, Boolean preventFling, Integer speed, GestureSourceType gestureSourceType, Integer repeatCount, Integer repeatDelayMs, String interactionMarkerName) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_synthesizeScrollGesture, CRT_SYNTHESIZE_SCROLL_GESTURE, PARAMS_SYNTHESIZE_SCROLL_GESTURE_2, new Object[]{x, y, xDistance, yDistance, xOverscroll, yOverscroll, preventFling, speed, gestureSourceType, repeatCount, repeatDelayMs, interactionMarkerName}, false);
    }

    @Override
    public CompletableFuture<Void> synthesizeTapGesture(Double x, Double y) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_synthesizeTapGesture, CRT_SYNTHESIZE_TAP_GESTURE, PARAMS_SYNTHESIZE_TAP_GESTURE_1, new Object[]{x, y}, false);
    }

    @Override
    public CompletableFuture<Void> synthesizeTapGesture(Double x, Double y, Integer duration, Integer tapCount, GestureSourceType gestureSourceType) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Input_synthesizeTapGesture, CRT_SYNTHESIZE_TAP_GESTURE, PARAMS_SYNTHESIZE_TAP_GESTURE_2, new Object[]{x, y, duration, tapCount, gestureSourceType}, false);
    }
}

