/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.TypeReference;
import io.webfolder.cdp.command.IndexedDB;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.indexeddb.DatabaseWithObjectStores;
import io.webfolder.cdp.type.indexeddb.GetMetadataResult;
import io.webfolder.cdp.type.indexeddb.KeyRange;
import io.webfolder.cdp.type.indexeddb.RequestDataResult;
import java.lang.reflect.Type;
import java.util.List;

class IndexedDBImpl
implements IndexedDB {
    private static final TypeReference<List<String>> LIST_STRING = new TypeReference<List<String>>(){};
    private static final CommandReturnType CRT_CLEAR_OBJECT_STORE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DELETE_DATABASE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DELETE_OBJECT_STORE_ENTRIES = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_METADATA = new CommandReturnType(null, (Type)((Object)GetMetadataResult.class), null);
    private static final CommandReturnType CRT_REQUEST_DATA = new CommandReturnType(null, (Type)((Object)RequestDataResult.class), null);
    private static final CommandReturnType CRT_REQUEST_DATABASE = new CommandReturnType("databaseWithObjectStores", (Type)((Object)DatabaseWithObjectStores.class), null);
    private static final CommandReturnType CRT_REQUEST_DATABASE_NAMES = new CommandReturnType("databaseNames", (Type)((Object)List.class), LIST_STRING);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_CLEAR_OBJECT_STORE_1 = new String[]{"securityOrigin", "databaseName", "objectStoreName"};
    private static final String[] PARAMS_DELETE_DATABASE_1 = new String[]{"securityOrigin", "databaseName"};
    private static final String[] PARAMS_DELETE_OBJECT_STORE_ENTRIES_1 = new String[]{"securityOrigin", "databaseName", "objectStoreName", "keyRange"};
    private static final String[] PARAMS_GET_METADATA_1 = new String[]{"securityOrigin", "databaseName", "objectStoreName"};
    private static final String[] PARAMS_REQUEST_DATABASE_1 = new String[]{"securityOrigin", "databaseName"};
    private static final String[] PARAMS_REQUEST_DATABASE_NAMES_1 = new String[]{"securityOrigin"};
    private static final String[] PARAMS_REQUEST_DATA_1 = new String[]{"securityOrigin", "databaseName", "objectStoreName", "indexName", "skipCount", "pageSize"};
    private static final String[] PARAMS_REQUEST_DATA_2 = new String[]{"securityOrigin", "databaseName", "objectStoreName", "indexName", "skipCount", "pageSize", "keyRange"};
    private final SessionInvocationHandler handler;

    public IndexedDBImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void clearObjectStore(String securityOrigin, String databaseName, String objectStoreName) {
        this.handler.invoke(DomainCommand.IndexedDB_clearObjectStore, CRT_CLEAR_OBJECT_STORE, PARAMS_CLEAR_OBJECT_STORE_1, new Object[]{securityOrigin, databaseName, objectStoreName}, true);
    }

    @Override
    public void deleteDatabase(String securityOrigin, String databaseName) {
        this.handler.invoke(DomainCommand.IndexedDB_deleteDatabase, CRT_DELETE_DATABASE, PARAMS_DELETE_DATABASE_1, new Object[]{securityOrigin, databaseName}, true);
    }

    @Override
    public void deleteObjectStoreEntries(String securityOrigin, String databaseName, String objectStoreName, KeyRange keyRange) {
        this.handler.invoke(DomainCommand.IndexedDB_deleteObjectStoreEntries, CRT_DELETE_OBJECT_STORE_ENTRIES, PARAMS_DELETE_OBJECT_STORE_ENTRIES_1, new Object[]{securityOrigin, databaseName, objectStoreName, keyRange}, true);
    }

    @Override
    public void disable() {
        this.handler.invoke(DomainCommand.IndexedDB_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void enable() {
        this.handler.invoke(DomainCommand.IndexedDB_enable, CRT_ENABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public GetMetadataResult getMetadata(String securityOrigin, String databaseName, String objectStoreName) {
        return (GetMetadataResult)this.handler.invoke(DomainCommand.IndexedDB_getMetadata, CRT_GET_METADATA, PARAMS_GET_METADATA_1, new Object[]{securityOrigin, databaseName, objectStoreName}, true);
    }

    @Override
    public RequestDataResult requestData(String securityOrigin, String databaseName, String objectStoreName, String indexName, Integer skipCount, Integer pageSize) {
        return (RequestDataResult)this.handler.invoke(DomainCommand.IndexedDB_requestData, CRT_REQUEST_DATA, PARAMS_REQUEST_DATA_1, new Object[]{securityOrigin, databaseName, objectStoreName, indexName, skipCount, pageSize}, true);
    }

    @Override
    public RequestDataResult requestData(String securityOrigin, String databaseName, String objectStoreName, String indexName, Integer skipCount, Integer pageSize, KeyRange keyRange) {
        return (RequestDataResult)this.handler.invoke(DomainCommand.IndexedDB_requestData, CRT_REQUEST_DATA, PARAMS_REQUEST_DATA_2, new Object[]{securityOrigin, databaseName, objectStoreName, indexName, skipCount, pageSize, keyRange}, true);
    }

    @Override
    public DatabaseWithObjectStores requestDatabase(String securityOrigin, String databaseName) {
        return (DatabaseWithObjectStores)this.handler.invoke(DomainCommand.IndexedDB_requestDatabase, CRT_REQUEST_DATABASE, PARAMS_REQUEST_DATABASE_1, new Object[]{securityOrigin, databaseName}, true);
    }

    @Override
    public List<String> requestDatabaseNames(String securityOrigin) {
        return (List)this.handler.invoke(DomainCommand.IndexedDB_requestDatabaseNames, CRT_REQUEST_DATABASE_NAMES, PARAMS_REQUEST_DATABASE_NAMES_1, new Object[]{securityOrigin}, true);
    }
}

