/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.command.IOAsync;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.io.ReadResult;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;

class IOAsyncImpl
implements IOAsync {
    private static final CommandReturnType CRT_CLOSE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_READ = new CommandReturnType(null, (Type)((Object)ReadResult.class), null);
    private static final CommandReturnType CRT_RESOLVE_BLOB = new CommandReturnType("uuid", (Type)((Object)String.class), null);
    private static final String[] PARAMS_CLOSE_1 = new String[]{"handle"};
    private static final String[] PARAMS_READ_1 = new String[]{"handle"};
    private static final String[] PARAMS_READ_2 = new String[]{"handle", "offset", "size"};
    private static final String[] PARAMS_RESOLVE_BLOB_1 = new String[]{"objectId"};
    private final SessionInvocationHandler handler;

    public IOAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<Void> close(String handle) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.IO_close, CRT_CLOSE, PARAMS_CLOSE_1, new Object[]{handle}, false);
    }

    @Override
    public CompletableFuture<ReadResult> read(String handle) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.IO_read, CRT_READ, PARAMS_READ_1, new Object[]{handle}, false);
    }

    @Override
    public CompletableFuture<ReadResult> read(String handle, Integer offset, Integer size) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.IO_read, CRT_READ, PARAMS_READ_2, new Object[]{handle, offset, size}, false);
    }

    @Override
    public CompletableFuture<String> resolveBlob(String objectId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.IO_resolveBlob, CRT_RESOLVE_BLOB, PARAMS_RESOLVE_BLOB_1, new Object[]{objectId}, false);
    }
}

