/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.command.HeapProfiler;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.heapprofiler.SamplingHeapProfile;
import io.webfolder.cdp.type.runtime.RemoteObject;
import java.lang.reflect.Type;

public class HeapProfilerImpl
implements HeapProfiler {
    private static final CommandReturnType CRT_ADD_INSPECTED_HEAP_OBJECT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_COLLECT_GARBAGE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_HEAP_OBJECT_ID = new CommandReturnType("heapSnapshotObjectId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_GET_OBJECT_BY_HEAP_OBJECT_ID = new CommandReturnType("result", (Type)((Object)RemoteObject.class), null);
    private static final CommandReturnType CRT_GET_SAMPLING_PROFILE = new CommandReturnType("profile", (Type)((Object)SamplingHeapProfile.class), null);
    private static final CommandReturnType CRT_START_SAMPLING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_START_TRACKING_HEAP_OBJECTS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_STOP_SAMPLING = new CommandReturnType("profile", (Type)((Object)SamplingHeapProfile.class), null);
    private static final CommandReturnType CRT_STOP_TRACKING_HEAP_OBJECTS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_TAKE_HEAP_SNAPSHOT = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_ADD_INSPECTED_HEAP_OBJECT_1 = new String[]{"heapObjectId"};
    private static final String[] PARAMS_GET_HEAP_OBJECT_ID_1 = new String[]{"objectId"};
    private static final String[] PARAMS_GET_OBJECT_BY_HEAP_OBJECT_ID_1 = new String[]{"objectId"};
    private static final String[] PARAMS_GET_OBJECT_BY_HEAP_OBJECT_ID_2 = new String[]{"objectId", "objectGroup"};
    private static final String[] PARAMS_START_SAMPLING_2 = new String[]{"samplingInterval"};
    private static final String[] PARAMS_START_TRACKING_HEAP_OBJECTS_2 = new String[]{"trackAllocations"};
    private static final String[] PARAMS_STOP_TRACKING_HEAP_OBJECTS_2 = new String[]{"reportProgress", "treatGlobalObjectsAsRoots", "captureNumericValue", "exposeInternals"};
    private static final String[] PARAMS_TAKE_HEAP_SNAPSHOT_2 = new String[]{"reportProgress", "treatGlobalObjectsAsRoots", "captureNumericValue", "exposeInternals"};
    private final SessionInvocationHandler handler;

    public HeapProfilerImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void addInspectedHeapObject(String heapObjectId) {
        this.handler.invoke(DomainCommand.HeapProfiler_addInspectedHeapObject, CRT_ADD_INSPECTED_HEAP_OBJECT, PARAMS_ADD_INSPECTED_HEAP_OBJECT_1, new Object[]{heapObjectId}, true);
    }

    @Override
    public void collectGarbage() {
        this.handler.invoke(DomainCommand.HeapProfiler_collectGarbage, CRT_COLLECT_GARBAGE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void disable() {
        this.handler.invoke(DomainCommand.HeapProfiler_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void enable() {
        this.handler.invoke(DomainCommand.HeapProfiler_enable, CRT_ENABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public String getHeapObjectId(String objectId) {
        return (String)this.handler.invoke(DomainCommand.HeapProfiler_getHeapObjectId, CRT_GET_HEAP_OBJECT_ID, PARAMS_GET_HEAP_OBJECT_ID_1, new Object[]{objectId}, true);
    }

    @Override
    public RemoteObject getObjectByHeapObjectId(String objectId) {
        return (RemoteObject)this.handler.invoke(DomainCommand.HeapProfiler_getObjectByHeapObjectId, CRT_GET_OBJECT_BY_HEAP_OBJECT_ID, PARAMS_GET_OBJECT_BY_HEAP_OBJECT_ID_1, new Object[]{objectId}, true);
    }

    @Override
    public RemoteObject getObjectByHeapObjectId(String objectId, String objectGroup) {
        return (RemoteObject)this.handler.invoke(DomainCommand.HeapProfiler_getObjectByHeapObjectId, CRT_GET_OBJECT_BY_HEAP_OBJECT_ID, PARAMS_GET_OBJECT_BY_HEAP_OBJECT_ID_2, new Object[]{objectId, objectGroup}, true);
    }

    @Override
    public SamplingHeapProfile getSamplingProfile() {
        return (SamplingHeapProfile)this.handler.invoke(DomainCommand.HeapProfiler_getSamplingProfile, CRT_GET_SAMPLING_PROFILE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void startSampling() {
        this.handler.invoke(DomainCommand.HeapProfiler_startSampling, CRT_START_SAMPLING, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void startSampling(Double samplingInterval) {
        this.handler.invoke(DomainCommand.HeapProfiler_startSampling, CRT_START_SAMPLING, PARAMS_START_SAMPLING_2, new Object[]{samplingInterval}, true);
    }

    @Override
    public void startTrackingHeapObjects() {
        this.handler.invoke(DomainCommand.HeapProfiler_startTrackingHeapObjects, CRT_START_TRACKING_HEAP_OBJECTS, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void startTrackingHeapObjects(Boolean trackAllocations) {
        this.handler.invoke(DomainCommand.HeapProfiler_startTrackingHeapObjects, CRT_START_TRACKING_HEAP_OBJECTS, PARAMS_START_TRACKING_HEAP_OBJECTS_2, new Object[]{trackAllocations}, true);
    }

    @Override
    public SamplingHeapProfile stopSampling() {
        return (SamplingHeapProfile)this.handler.invoke(DomainCommand.HeapProfiler_stopSampling, CRT_STOP_SAMPLING, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void stopTrackingHeapObjects() {
        this.handler.invoke(DomainCommand.HeapProfiler_stopTrackingHeapObjects, CRT_STOP_TRACKING_HEAP_OBJECTS, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void stopTrackingHeapObjects(Boolean reportProgress, Boolean treatGlobalObjectsAsRoots, Boolean captureNumericValue, Boolean exposeInternals) {
        this.handler.invoke(DomainCommand.HeapProfiler_stopTrackingHeapObjects, CRT_STOP_TRACKING_HEAP_OBJECTS, PARAMS_STOP_TRACKING_HEAP_OBJECTS_2, new Object[]{reportProgress, treatGlobalObjectsAsRoots, captureNumericValue, exposeInternals}, true);
    }

    @Override
    public void takeHeapSnapshot() {
        this.handler.invoke(DomainCommand.HeapProfiler_takeHeapSnapshot, CRT_TAKE_HEAP_SNAPSHOT, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void takeHeapSnapshot(Boolean reportProgress, Boolean treatGlobalObjectsAsRoots, Boolean captureNumericValue, Boolean exposeInternals) {
        this.handler.invoke(DomainCommand.HeapProfiler_takeHeapSnapshot, CRT_TAKE_HEAP_SNAPSHOT, PARAMS_TAKE_HEAP_SNAPSHOT_2, new Object[]{reportProgress, treatGlobalObjectsAsRoots, captureNumericValue, exposeInternals}, true);
    }
}

