/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.command.Fetch;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.fetch.AuthChallengeResponse;
import io.webfolder.cdp.type.fetch.GetResponseBodyResult;
import io.webfolder.cdp.type.fetch.HeaderEntry;
import io.webfolder.cdp.type.fetch.RequestPattern;
import io.webfolder.cdp.type.network.ErrorReason;
import java.lang.reflect.Type;
import java.util.List;

class FetchImpl
implements Fetch {
    private static final CommandReturnType CRT_CONTINUE_REQUEST = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CONTINUE_RESPONSE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CONTINUE_WITH_AUTH = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_FAIL_REQUEST = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_FULFILL_REQUEST = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_RESPONSE_BODY = new CommandReturnType(null, (Type)((Object)GetResponseBodyResult.class), null);
    private static final CommandReturnType CRT_TAKE_RESPONSE_BODY_AS_STREAM = new CommandReturnType("stream", (Type)((Object)String.class), null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_CONTINUE_REQUEST_1 = new String[]{"requestId"};
    private static final String[] PARAMS_CONTINUE_REQUEST_2 = new String[]{"requestId", "url", "method", "postData", "headers", "interceptResponse"};
    private static final String[] PARAMS_CONTINUE_RESPONSE_1 = new String[]{"requestId"};
    private static final String[] PARAMS_CONTINUE_RESPONSE_2 = new String[]{"requestId", "responseCode", "responsePhrase", "responseHeaders", "binaryResponseHeaders"};
    private static final String[] PARAMS_CONTINUE_WITH_AUTH_1 = new String[]{"requestId", "authChallengeResponse"};
    private static final String[] PARAMS_ENABLE_2 = new String[]{"patterns", "handleAuthRequests"};
    private static final String[] PARAMS_FAIL_REQUEST_1 = new String[]{"requestId", "errorReason"};
    private static final String[] PARAMS_FULFILL_REQUEST_1 = new String[]{"requestId", "responseCode"};
    private static final String[] PARAMS_FULFILL_REQUEST_2 = new String[]{"requestId", "responseCode", "responseHeaders", "binaryResponseHeaders", "body", "responsePhrase"};
    private static final String[] PARAMS_GET_RESPONSE_BODY_1 = new String[]{"requestId"};
    private static final String[] PARAMS_TAKE_RESPONSE_BODY_AS_STREAM_1 = new String[]{"requestId"};
    private final SessionInvocationHandler handler;

    public FetchImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void continueRequest(String requestId) {
        this.handler.invoke(DomainCommand.Fetch_continueRequest, CRT_CONTINUE_REQUEST, PARAMS_CONTINUE_REQUEST_1, new Object[]{requestId}, true);
    }

    @Override
    public void continueRequest(String requestId, String url, String method, String postData, List<HeaderEntry> headers, Boolean interceptResponse) {
        this.handler.invoke(DomainCommand.Fetch_continueRequest, CRT_CONTINUE_REQUEST, PARAMS_CONTINUE_REQUEST_2, new Object[]{requestId, url, method, postData, headers, interceptResponse}, true);
    }

    @Override
    public void continueResponse(String requestId) {
        this.handler.invoke(DomainCommand.Fetch_continueResponse, CRT_CONTINUE_RESPONSE, PARAMS_CONTINUE_RESPONSE_1, new Object[]{requestId}, true);
    }

    @Override
    public void continueResponse(String requestId, Integer responseCode, String responsePhrase, List<HeaderEntry> responseHeaders, String binaryResponseHeaders) {
        this.handler.invoke(DomainCommand.Fetch_continueResponse, CRT_CONTINUE_RESPONSE, PARAMS_CONTINUE_RESPONSE_2, new Object[]{requestId, responseCode, responsePhrase, responseHeaders, binaryResponseHeaders}, true);
    }

    @Override
    public void continueWithAuth(String requestId, AuthChallengeResponse authChallengeResponse) {
        this.handler.invoke(DomainCommand.Fetch_continueWithAuth, CRT_CONTINUE_WITH_AUTH, PARAMS_CONTINUE_WITH_AUTH_1, new Object[]{requestId, authChallengeResponse}, true);
    }

    @Override
    public void disable() {
        this.handler.invoke(DomainCommand.Fetch_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void enable() {
        this.handler.invoke(DomainCommand.Fetch_enable, CRT_ENABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void enable(List<RequestPattern> patterns, Boolean handleAuthRequests) {
        this.handler.invoke(DomainCommand.Fetch_enable, CRT_ENABLE, PARAMS_ENABLE_2, new Object[]{patterns, handleAuthRequests}, true);
    }

    @Override
    public void failRequest(String requestId, ErrorReason errorReason) {
        this.handler.invoke(DomainCommand.Fetch_failRequest, CRT_FAIL_REQUEST, PARAMS_FAIL_REQUEST_1, new Object[]{requestId, errorReason}, true);
    }

    @Override
    public void fulfillRequest(String requestId, Integer responseCode) {
        this.handler.invoke(DomainCommand.Fetch_fulfillRequest, CRT_FULFILL_REQUEST, PARAMS_FULFILL_REQUEST_1, new Object[]{requestId, responseCode}, true);
    }

    @Override
    public void fulfillRequest(String requestId, Integer responseCode, List<HeaderEntry> responseHeaders, String binaryResponseHeaders, String body, String responsePhrase) {
        this.handler.invoke(DomainCommand.Fetch_fulfillRequest, CRT_FULFILL_REQUEST, PARAMS_FULFILL_REQUEST_2, new Object[]{requestId, responseCode, responseHeaders, binaryResponseHeaders, body, responsePhrase}, true);
    }

    @Override
    public GetResponseBodyResult getResponseBody(String requestId) {
        return (GetResponseBodyResult)this.handler.invoke(DomainCommand.Fetch_getResponseBody, CRT_GET_RESPONSE_BODY, PARAMS_GET_RESPONSE_BODY_1, new Object[]{requestId}, true);
    }

    @Override
    public String takeResponseBodyAsStream(String requestId) {
        return (String)this.handler.invoke(DomainCommand.Fetch_takeResponseBodyAsStream, CRT_TAKE_RESPONSE_BODY_AS_STREAM, PARAMS_TAKE_RESPONSE_BODY_AS_STREAM_1, new Object[]{requestId}, true);
    }
}

