/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.TypeReference;
import io.webfolder.cdp.command.DatabaseAsync;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.database.ExecuteSQLResult;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class DatabaseAsyncImpl
implements DatabaseAsync {
    private static final TypeReference<List<String>> LIST_STRING = new TypeReference<List<String>>(){};
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_EXECUTE_SQ_L = new CommandReturnType(null, (Type)((Object)ExecuteSQLResult.class), null);
    private static final CommandReturnType CRT_GET_DATABASE_TABLE_NAMES = new CommandReturnType("tableNames", (Type)((Object)List.class), LIST_STRING);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_EXECUTE_SQ_L_1 = new String[]{"databaseId", "query"};
    private static final String[] PARAMS_GET_DATABASE_TABLE_NAMES_1 = new String[]{"databaseId"};
    private final SessionInvocationHandler handler;

    public DatabaseAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<Void> disable() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Database_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> enable() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Database_enable, CRT_ENABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<ExecuteSQLResult> executeSQL(String databaseId, String query) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Database_executeSQL, CRT_EXECUTE_SQ_L, PARAMS_EXECUTE_SQ_L_1, new Object[]{databaseId, query}, false);
    }

    @Override
    public CompletableFuture<List<String>> getDatabaseTableNames(String databaseId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Database_getDatabaseTableNames, CRT_GET_DATABASE_TABLE_NAMES, PARAMS_GET_DATABASE_TABLE_NAMES_1, new Object[]{databaseId}, false);
    }
}

