/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.TypeReference;
import io.webfolder.cdp.command.DOMStorage;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.domstorage.StorageId;
import java.lang.reflect.Type;
import java.util.List;

class DOMStorageImpl
implements DOMStorage {
    private static final TypeReference<List<List<String>>> LIST_LIST_STRING = new TypeReference<List<List<String>>>(){};
    private static final CommandReturnType CRT_CLEAR = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_DO_MSTORAGE_ITEMS = new CommandReturnType("entries", (Type)((Object)List.class), LIST_LIST_STRING);
    private static final CommandReturnType CRT_REMOVE_DO_MSTORAGE_ITEM = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_DO_MSTORAGE_ITEM = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_CLEAR_1 = new String[]{"storageId"};
    private static final String[] PARAMS_GET_DO_MSTORAGE_ITEMS_1 = new String[]{"storageId"};
    private static final String[] PARAMS_REMOVE_DO_MSTORAGE_ITEM_1 = new String[]{"storageId", "key"};
    private static final String[] PARAMS_SET_DO_MSTORAGE_ITEM_1 = new String[]{"storageId", "key", "value"};
    private final SessionInvocationHandler handler;

    public DOMStorageImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void clear(StorageId storageId) {
        this.handler.invoke(DomainCommand.DOMStorage_clear, CRT_CLEAR, PARAMS_CLEAR_1, new Object[]{storageId}, true);
    }

    @Override
    public void disable() {
        this.handler.invoke(DomainCommand.DOMStorage_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void enable() {
        this.handler.invoke(DomainCommand.DOMStorage_enable, CRT_ENABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public List<List<String>> getDOMStorageItems(StorageId storageId) {
        return (List)this.handler.invoke(DomainCommand.DOMStorage_getDOMStorageItems, CRT_GET_DO_MSTORAGE_ITEMS, PARAMS_GET_DO_MSTORAGE_ITEMS_1, new Object[]{storageId}, true);
    }

    @Override
    public void removeDOMStorageItem(StorageId storageId, String key) {
        this.handler.invoke(DomainCommand.DOMStorage_removeDOMStorageItem, CRT_REMOVE_DO_MSTORAGE_ITEM, PARAMS_REMOVE_DO_MSTORAGE_ITEM_1, new Object[]{storageId, key}, true);
    }

    @Override
    public void setDOMStorageItem(StorageId storageId, String key, String value) {
        this.handler.invoke(DomainCommand.DOMStorage_setDOMStorageItem, CRT_SET_DO_MSTORAGE_ITEM, PARAMS_SET_DO_MSTORAGE_ITEM_1, new Object[]{storageId, key, value}, true);
    }
}

