/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.TypeReference;
import io.webfolder.cdp.command.CSSAsync;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.css.CSSComputedStyleProperty;
import io.webfolder.cdp.type.css.CSSContainerQuery;
import io.webfolder.cdp.type.css.CSSLayerData;
import io.webfolder.cdp.type.css.CSSMedia;
import io.webfolder.cdp.type.css.CSSRule;
import io.webfolder.cdp.type.css.CSSStyle;
import io.webfolder.cdp.type.css.CSSSupports;
import io.webfolder.cdp.type.css.GetBackgroundColorsResult;
import io.webfolder.cdp.type.css.GetInlineStylesForNodeResult;
import io.webfolder.cdp.type.css.GetMatchedStylesForNodeResult;
import io.webfolder.cdp.type.css.PlatformFontUsage;
import io.webfolder.cdp.type.css.RuleUsage;
import io.webfolder.cdp.type.css.SelectorList;
import io.webfolder.cdp.type.css.SourceRange;
import io.webfolder.cdp.type.css.StyleDeclarationEdit;
import io.webfolder.cdp.type.css.TakeCoverageDeltaResult;
import io.webfolder.cdp.type.css.Value;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class CSSAsyncImpl
implements CSSAsync {
    private static final TypeReference<List<CSSComputedStyleProperty>> LIST_CSSCOMPUTEDSTYLEPROPERTY = new TypeReference<List<CSSComputedStyleProperty>>(){};
    private static final TypeReference<List<CSSMedia>> LIST_CSSMEDIA = new TypeReference<List<CSSMedia>>(){};
    private static final TypeReference<List<CSSStyle>> LIST_CSSSTYLE = new TypeReference<List<CSSStyle>>(){};
    private static final TypeReference<List<Integer>> LIST_INTEGER = new TypeReference<List<Integer>>(){};
    private static final TypeReference<List<PlatformFontUsage>> LIST_PLATFORMFONTUSAGE = new TypeReference<List<PlatformFontUsage>>(){};
    private static final TypeReference<List<RuleUsage>> LIST_RULEUSAGE = new TypeReference<List<RuleUsage>>(){};
    private static final TypeReference<List<String>> LIST_STRING = new TypeReference<List<String>>(){};
    private static final CommandReturnType CRT_ADD_RULE = new CommandReturnType("rule", (Type)((Object)CSSRule.class), null);
    private static final CommandReturnType CRT_COLLECT_CLASS_NAMES = new CommandReturnType("classNames", (Type)((Object)List.class), LIST_STRING);
    private static final CommandReturnType CRT_CREATE_STYLE_SHEET = new CommandReturnType("styleSheetId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_FORCE_PSEUDO_STATE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_BACKGROUND_COLORS = new CommandReturnType(null, (Type)((Object)GetBackgroundColorsResult.class), null);
    private static final CommandReturnType CRT_GET_COMPUTED_STYLE_FOR_NODE = new CommandReturnType("computedStyle", (Type)((Object)List.class), LIST_CSSCOMPUTEDSTYLEPROPERTY);
    private static final CommandReturnType CRT_GET_INLINE_STYLES_FOR_NODE = new CommandReturnType(null, (Type)((Object)GetInlineStylesForNodeResult.class), null);
    private static final CommandReturnType CRT_GET_LAYERS_FOR_NODE = new CommandReturnType("rootLayer", (Type)((Object)CSSLayerData.class), null);
    private static final CommandReturnType CRT_GET_MATCHED_STYLES_FOR_NODE = new CommandReturnType(null, (Type)((Object)GetMatchedStylesForNodeResult.class), null);
    private static final CommandReturnType CRT_GET_MEDIA_QUERIES = new CommandReturnType("medias", (Type)((Object)List.class), LIST_CSSMEDIA);
    private static final CommandReturnType CRT_GET_PLATFORM_FONTS_FOR_NODE = new CommandReturnType("fonts", (Type)((Object)List.class), LIST_PLATFORMFONTUSAGE);
    private static final CommandReturnType CRT_GET_STYLE_SHEET_TEXT = new CommandReturnType("text", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_SET_CONTAINER_QUERY_TEXT = new CommandReturnType("containerQuery", (Type)((Object)CSSContainerQuery.class), null);
    private static final CommandReturnType CRT_SET_EFFECTIVE_PROPERTY_VALUE_FOR_NODE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_KEYFRAME_KEY = new CommandReturnType("keyText", (Type)((Object)Value.class), null);
    private static final CommandReturnType CRT_SET_LOCAL_FONTS_ENABLED = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_MEDIA_TEXT = new CommandReturnType("media", (Type)((Object)CSSMedia.class), null);
    private static final CommandReturnType CRT_SET_RULE_SELECTOR = new CommandReturnType("selectorList", (Type)((Object)SelectorList.class), null);
    private static final CommandReturnType CRT_SET_STYLE_SHEET_TEXT = new CommandReturnType("sourceMapURL", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_SET_STYLE_TEXTS = new CommandReturnType("styles", (Type)((Object)List.class), LIST_CSSSTYLE);
    private static final CommandReturnType CRT_SET_SUPPORTS_TEXT = new CommandReturnType("supports", (Type)((Object)CSSSupports.class), null);
    private static final CommandReturnType CRT_START_RULE_USAGE_TRACKING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_STOP_RULE_USAGE_TRACKING = new CommandReturnType("ruleUsage", (Type)((Object)List.class), LIST_RULEUSAGE);
    private static final CommandReturnType CRT_TAKE_COMPUTED_STYLE_UPDATES = new CommandReturnType("nodeIds", (Type)((Object)List.class), LIST_INTEGER);
    private static final CommandReturnType CRT_TAKE_COVERAGE_DELTA = new CommandReturnType(null, (Type)((Object)TakeCoverageDeltaResult.class), null);
    private static final CommandReturnType CRT_TRACK_COMPUTED_STYLE_UPDATES = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_ADD_RULE_1 = new String[]{"styleSheetId", "ruleText", "location"};
    private static final String[] PARAMS_COLLECT_CLASS_NAMES_1 = new String[]{"styleSheetId"};
    private static final String[] PARAMS_CREATE_STYLE_SHEET_1 = new String[]{"frameId"};
    private static final String[] PARAMS_FORCE_PSEUDO_STATE_1 = new String[]{"nodeId", "forcedPseudoClasses"};
    private static final String[] PARAMS_GET_BACKGROUND_COLORS_1 = new String[]{"nodeId"};
    private static final String[] PARAMS_GET_COMPUTED_STYLE_FOR_NODE_1 = new String[]{"nodeId"};
    private static final String[] PARAMS_GET_INLINE_STYLES_FOR_NODE_1 = new String[]{"nodeId"};
    private static final String[] PARAMS_GET_LAYERS_FOR_NODE_1 = new String[]{"nodeId"};
    private static final String[] PARAMS_GET_MATCHED_STYLES_FOR_NODE_1 = new String[]{"nodeId"};
    private static final String[] PARAMS_GET_PLATFORM_FONTS_FOR_NODE_1 = new String[]{"nodeId"};
    private static final String[] PARAMS_GET_STYLE_SHEET_TEXT_1 = new String[]{"styleSheetId"};
    private static final String[] PARAMS_SET_CONTAINER_QUERY_TEXT_1 = new String[]{"styleSheetId", "range", "text"};
    private static final String[] PARAMS_SET_EFFECTIVE_PROPERTY_VALUE_FOR_NODE_1 = new String[]{"nodeId", "propertyName", "value"};
    private static final String[] PARAMS_SET_KEYFRAME_KEY_1 = new String[]{"styleSheetId", "range", "keyText"};
    private static final String[] PARAMS_SET_LOCAL_FONTS_ENABLED_1 = new String[]{"enabled"};
    private static final String[] PARAMS_SET_MEDIA_TEXT_1 = new String[]{"styleSheetId", "range", "text"};
    private static final String[] PARAMS_SET_RULE_SELECTOR_1 = new String[]{"styleSheetId", "range", "selector"};
    private static final String[] PARAMS_SET_STYLE_SHEET_TEXT_1 = new String[]{"styleSheetId", "text"};
    private static final String[] PARAMS_SET_STYLE_TEXTS_1 = new String[]{"edits"};
    private static final String[] PARAMS_SET_SUPPORTS_TEXT_1 = new String[]{"styleSheetId", "range", "text"};
    private static final String[] PARAMS_TRACK_COMPUTED_STYLE_UPDATES_1 = new String[]{"propertiesToTrack"};
    private final SessionInvocationHandler handler;

    public CSSAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<CSSRule> addRule(String styleSheetId, String ruleText, SourceRange location) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_addRule, CRT_ADD_RULE, PARAMS_ADD_RULE_1, new Object[]{styleSheetId, ruleText, location}, false);
    }

    @Override
    public CompletableFuture<List<String>> collectClassNames(String styleSheetId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_collectClassNames, CRT_COLLECT_CLASS_NAMES, PARAMS_COLLECT_CLASS_NAMES_1, new Object[]{styleSheetId}, false);
    }

    @Override
    public CompletableFuture<String> createStyleSheet(String frameId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_createStyleSheet, CRT_CREATE_STYLE_SHEET, PARAMS_CREATE_STYLE_SHEET_1, new Object[]{frameId}, false);
    }

    @Override
    public CompletableFuture<Void> disable() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> enable() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_enable, CRT_ENABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> forcePseudoState(Integer nodeId, List<String> forcedPseudoClasses) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_forcePseudoState, CRT_FORCE_PSEUDO_STATE, PARAMS_FORCE_PSEUDO_STATE_1, new Object[]{nodeId, forcedPseudoClasses}, false);
    }

    @Override
    public CompletableFuture<GetBackgroundColorsResult> getBackgroundColors(Integer nodeId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_getBackgroundColors, CRT_GET_BACKGROUND_COLORS, PARAMS_GET_BACKGROUND_COLORS_1, new Object[]{nodeId}, false);
    }

    @Override
    public CompletableFuture<List<CSSComputedStyleProperty>> getComputedStyleForNode(Integer nodeId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_getComputedStyleForNode, CRT_GET_COMPUTED_STYLE_FOR_NODE, PARAMS_GET_COMPUTED_STYLE_FOR_NODE_1, new Object[]{nodeId}, false);
    }

    @Override
    public CompletableFuture<GetInlineStylesForNodeResult> getInlineStylesForNode(Integer nodeId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_getInlineStylesForNode, CRT_GET_INLINE_STYLES_FOR_NODE, PARAMS_GET_INLINE_STYLES_FOR_NODE_1, new Object[]{nodeId}, false);
    }

    @Override
    public CompletableFuture<CSSLayerData> getLayersForNode(Integer nodeId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_getLayersForNode, CRT_GET_LAYERS_FOR_NODE, PARAMS_GET_LAYERS_FOR_NODE_1, new Object[]{nodeId}, false);
    }

    @Override
    public CompletableFuture<GetMatchedStylesForNodeResult> getMatchedStylesForNode(Integer nodeId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_getMatchedStylesForNode, CRT_GET_MATCHED_STYLES_FOR_NODE, PARAMS_GET_MATCHED_STYLES_FOR_NODE_1, new Object[]{nodeId}, false);
    }

    @Override
    public CompletableFuture<List<CSSMedia>> getMediaQueries() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_getMediaQueries, CRT_GET_MEDIA_QUERIES, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<PlatformFontUsage>> getPlatformFontsForNode(Integer nodeId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_getPlatformFontsForNode, CRT_GET_PLATFORM_FONTS_FOR_NODE, PARAMS_GET_PLATFORM_FONTS_FOR_NODE_1, new Object[]{nodeId}, false);
    }

    @Override
    public CompletableFuture<String> getStyleSheetText(String styleSheetId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_getStyleSheetText, CRT_GET_STYLE_SHEET_TEXT, PARAMS_GET_STYLE_SHEET_TEXT_1, new Object[]{styleSheetId}, false);
    }

    @Override
    public CompletableFuture<CSSContainerQuery> setContainerQueryText(String styleSheetId, SourceRange range, String text) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_setContainerQueryText, CRT_SET_CONTAINER_QUERY_TEXT, PARAMS_SET_CONTAINER_QUERY_TEXT_1, new Object[]{styleSheetId, range, text}, false);
    }

    @Override
    public CompletableFuture<Void> setEffectivePropertyValueForNode(Integer nodeId, String propertyName, String value) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_setEffectivePropertyValueForNode, CRT_SET_EFFECTIVE_PROPERTY_VALUE_FOR_NODE, PARAMS_SET_EFFECTIVE_PROPERTY_VALUE_FOR_NODE_1, new Object[]{nodeId, propertyName, value}, false);
    }

    @Override
    public CompletableFuture<Value> setKeyframeKey(String styleSheetId, SourceRange range, String keyText) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_setKeyframeKey, CRT_SET_KEYFRAME_KEY, PARAMS_SET_KEYFRAME_KEY_1, new Object[]{styleSheetId, range, keyText}, false);
    }

    @Override
    public CompletableFuture<Void> setLocalFontsEnabled(Boolean enabled) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_setLocalFontsEnabled, CRT_SET_LOCAL_FONTS_ENABLED, PARAMS_SET_LOCAL_FONTS_ENABLED_1, new Object[]{enabled}, false);
    }

    @Override
    public CompletableFuture<CSSMedia> setMediaText(String styleSheetId, SourceRange range, String text) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_setMediaText, CRT_SET_MEDIA_TEXT, PARAMS_SET_MEDIA_TEXT_1, new Object[]{styleSheetId, range, text}, false);
    }

    @Override
    public CompletableFuture<SelectorList> setRuleSelector(String styleSheetId, SourceRange range, String selector) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_setRuleSelector, CRT_SET_RULE_SELECTOR, PARAMS_SET_RULE_SELECTOR_1, new Object[]{styleSheetId, range, selector}, false);
    }

    @Override
    public CompletableFuture<String> setStyleSheetText(String styleSheetId, String text) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_setStyleSheetText, CRT_SET_STYLE_SHEET_TEXT, PARAMS_SET_STYLE_SHEET_TEXT_1, new Object[]{styleSheetId, text}, false);
    }

    @Override
    public CompletableFuture<List<CSSStyle>> setStyleTexts(List<StyleDeclarationEdit> edits) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_setStyleTexts, CRT_SET_STYLE_TEXTS, PARAMS_SET_STYLE_TEXTS_1, new Object[]{edits}, false);
    }

    @Override
    public CompletableFuture<CSSSupports> setSupportsText(String styleSheetId, SourceRange range, String text) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_setSupportsText, CRT_SET_SUPPORTS_TEXT, PARAMS_SET_SUPPORTS_TEXT_1, new Object[]{styleSheetId, range, text}, false);
    }

    @Override
    public CompletableFuture<Void> startRuleUsageTracking() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_startRuleUsageTracking, CRT_START_RULE_USAGE_TRACKING, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<RuleUsage>> stopRuleUsageTracking() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_stopRuleUsageTracking, CRT_STOP_RULE_USAGE_TRACKING, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<Integer>> takeComputedStyleUpdates() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_takeComputedStyleUpdates, CRT_TAKE_COMPUTED_STYLE_UPDATES, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<TakeCoverageDeltaResult> takeCoverageDelta() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_takeCoverageDelta, CRT_TAKE_COVERAGE_DELTA, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> trackComputedStyleUpdates(List<CSSComputedStyleProperty> propertiesToTrack) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.CSS_trackComputedStyleUpdates, CRT_TRACK_COMPUTED_STYLE_UPDATES, PARAMS_TRACK_COMPUTED_STYLE_UPDATES_1, new Object[]{propertiesToTrack}, false);
    }
}

