/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.command.BackgroundService;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.backgroundservice.ServiceName;

class BackgroundServiceImpl
implements BackgroundService {
    private static final CommandReturnType CRT_CLEAR_EVENTS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_RECORDING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_START_OBSERVING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_STOP_OBSERVING = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] PARAMS_CLEAR_EVENTS_1 = new String[]{"service"};
    private static final String[] PARAMS_SET_RECORDING_1 = new String[]{"shouldRecord", "service"};
    private static final String[] PARAMS_START_OBSERVING_1 = new String[]{"service"};
    private static final String[] PARAMS_STOP_OBSERVING_1 = new String[]{"service"};
    private final SessionInvocationHandler handler;

    public BackgroundServiceImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void clearEvents(ServiceName service) {
        this.handler.invoke(DomainCommand.BackgroundService_clearEvents, CRT_CLEAR_EVENTS, PARAMS_CLEAR_EVENTS_1, new Object[]{service}, true);
    }

    @Override
    public void setRecording(Boolean shouldRecord, ServiceName service) {
        this.handler.invoke(DomainCommand.BackgroundService_setRecording, CRT_SET_RECORDING, PARAMS_SET_RECORDING_1, new Object[]{shouldRecord, service}, true);
    }

    @Override
    public void startObserving(ServiceName service) {
        this.handler.invoke(DomainCommand.BackgroundService_startObserving, CRT_START_OBSERVING, PARAMS_START_OBSERVING_1, new Object[]{service}, true);
    }

    @Override
    public void stopObserving(ServiceName service) {
        this.handler.invoke(DomainCommand.BackgroundService_stopObserving, CRT_STOP_OBSERVING, PARAMS_STOP_OBSERVING_1, new Object[]{service}, true);
    }
}

