/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.TypeReference;
import io.webfolder.cdp.command.AccessibilityAsync;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.accessibility.AXNode;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class AccessibilityAsyncImpl
implements AccessibilityAsync {
    private static final TypeReference<List<AXNode>> LIST_AXNODE = new TypeReference<List<AXNode>>(){};
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_AX_NODE_AND_ANCESTORS = new CommandReturnType("nodes", (Type)((Object)List.class), LIST_AXNODE);
    private static final CommandReturnType CRT_GET_CHILD_AX_NODES = new CommandReturnType("nodes", (Type)((Object)List.class), LIST_AXNODE);
    private static final CommandReturnType CRT_GET_FULL_AX_TREE = new CommandReturnType("nodes", (Type)((Object)List.class), LIST_AXNODE);
    private static final CommandReturnType CRT_GET_PARTIAL_AX_TREE = new CommandReturnType("nodes", (Type)((Object)List.class), LIST_AXNODE);
    private static final CommandReturnType CRT_GET_ROOT_AX_NODE = new CommandReturnType("node", (Type)((Object)AXNode.class), null);
    private static final CommandReturnType CRT_QUERY_AX_TREE = new CommandReturnType("nodes", (Type)((Object)List.class), LIST_AXNODE);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_GET_AX_NODE_AND_ANCESTORS_2 = new String[]{"nodeId", "backendNodeId", "objectId"};
    private static final String[] PARAMS_GET_CHILD_AX_NODES_1 = new String[]{"id"};
    private static final String[] PARAMS_GET_CHILD_AX_NODES_2 = new String[]{"id", "frameId"};
    private static final String[] PARAMS_GET_FULL_AX_TREE_2 = new String[]{"depth", "frameId"};
    private static final String[] PARAMS_GET_PARTIAL_AX_TREE_2 = new String[]{"nodeId", "backendNodeId", "objectId", "fetchRelatives"};
    private static final String[] PARAMS_GET_ROOT_AX_NODE_2 = new String[]{"frameId"};
    private static final String[] PARAMS_QUERY_AX_TREE_2 = new String[]{"nodeId", "backendNodeId", "objectId", "accessibleName", "role"};
    private final SessionInvocationHandler handler;

    public AccessibilityAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<Void> disable() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> enable() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_enable, CRT_ENABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<AXNode>> getAXNodeAndAncestors() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_getAXNodeAndAncestors, CRT_GET_AX_NODE_AND_ANCESTORS, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<AXNode>> getAXNodeAndAncestors(Integer nodeId, Integer backendNodeId, String objectId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_getAXNodeAndAncestors, CRT_GET_AX_NODE_AND_ANCESTORS, PARAMS_GET_AX_NODE_AND_ANCESTORS_2, new Object[]{nodeId, backendNodeId, objectId}, false);
    }

    @Override
    public CompletableFuture<List<AXNode>> getChildAXNodes(String id) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_getChildAXNodes, CRT_GET_CHILD_AX_NODES, PARAMS_GET_CHILD_AX_NODES_1, new Object[]{id}, false);
    }

    @Override
    public CompletableFuture<List<AXNode>> getChildAXNodes(String id, String frameId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_getChildAXNodes, CRT_GET_CHILD_AX_NODES, PARAMS_GET_CHILD_AX_NODES_2, new Object[]{id, frameId}, false);
    }

    @Override
    public CompletableFuture<List<AXNode>> getFullAXTree() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_getFullAXTree, CRT_GET_FULL_AX_TREE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<AXNode>> getFullAXTree(Integer depth, String frameId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_getFullAXTree, CRT_GET_FULL_AX_TREE, PARAMS_GET_FULL_AX_TREE_2, new Object[]{depth, frameId}, false);
    }

    @Override
    public CompletableFuture<List<AXNode>> getPartialAXTree() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_getPartialAXTree, CRT_GET_PARTIAL_AX_TREE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<AXNode>> getPartialAXTree(Integer nodeId, Integer backendNodeId, String objectId, Boolean fetchRelatives) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_getPartialAXTree, CRT_GET_PARTIAL_AX_TREE, PARAMS_GET_PARTIAL_AX_TREE_2, new Object[]{nodeId, backendNodeId, objectId, fetchRelatives}, false);
    }

    @Override
    public CompletableFuture<AXNode> getRootAXNode() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_getRootAXNode, CRT_GET_ROOT_AX_NODE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<AXNode> getRootAXNode(String frameId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_getRootAXNode, CRT_GET_ROOT_AX_NODE, PARAMS_GET_ROOT_AX_NODE_2, new Object[]{frameId}, false);
    }

    @Override
    public CompletableFuture<List<AXNode>> queryAXTree() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_queryAXTree, CRT_QUERY_AX_TREE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<AXNode>> queryAXTree(Integer nodeId, Integer backendNodeId, String objectId, String accessibleName, String role) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Accessibility_queryAXTree, CRT_QUERY_AX_TREE, PARAMS_QUERY_AX_TREE_2, new Object[]{nodeId, backendNodeId, objectId, accessibleName, role}, false);
    }
}

