/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.netty.buffer.Unpooled;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.WebSocketFrameType;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.webfolder.cdp.JsonLibrary;
import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.CdpLoggerFactory;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class VertxWebSocketChannel
implements Channel {
    private final SessionFactory factory;
    private final MessageHandler handler;
    private final HttpClient httpClient;
    private final WebSocketConnectOptions options;
    private final CdpLogger log;
    private WebSocket webSocket;

    public VertxWebSocketChannel(SessionFactory factory, HttpClient httpClient, MessageHandler handler, WebSocketConnectOptions options) {
        this.factory = factory;
        this.httpClient = httpClient;
        this.handler = handler;
        this.options = options;
        this.log = new CdpLoggerFactory(factory.getOptions()).getLogger("cdp.vertx");
    }

    @Override
    public boolean isOpen() {
        return !this.webSocket.isClosed();
    }

    @Override
    public void disconnect() {
        if (!this.webSocket.isClosed()) {
            this.webSocket.close((short)1000, "done", event -> this.factory.close());
        }
    }

    @Override
    public void sendText(String message) {
        this.webSocket.writeFinalTextFrame(message);
    }

    @Override
    public void sendText(byte[] message) {
        WebSocketFrameImpl frame = new WebSocketFrameImpl(WebSocketFrameType.TEXT, Unpooled.wrappedBuffer((byte[])message), true);
        this.webSocket.writeFrame((WebSocketFrame)frame);
    }

    @Override
    public void connect() {
        Semaphore semaphore = new Semaphore(0);
        this.httpClient.webSocket(this.options, event -> {
            if (event.succeeded()) {
                this.webSocket = (WebSocket)event.result();
                this.webSocket.exceptionHandler(onError -> semaphore.release());
                if (JsonLibrary.Jackson.equals((Object)this.factory.getOptions().jsonLibrary())) {
                    this.webSocket.frameHandler(evnt -> {
                        if (evnt.isText() && evnt.isFinal()) {
                            this.handler.process(evnt.binaryData().getBytes());
                        }
                    });
                } else {
                    this.webSocket.textMessageHandler(content -> this.handler.process((String)content));
                }
                this.webSocket.closeHandler(onCloseEvent -> this.factory.close());
            } else if (event.failed() && event.cause() != null) {
                this.log.error(event.cause().getMessage(), event.cause());
            }
            semaphore.release();
        });
        try {
            semaphore.tryAcquire(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new CdpException(e);
        }
        if (this.webSocket == null) {
            throw new CdpException("Can not establish WebSocket connection.");
        }
    }
}

