/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;

@ClientEndpoint
public class StandardWebSocketListener
extends Endpoint
implements MessageHandler.Partial<String> {
    private final SessionFactory factory;
    private final MessageHandler handler;
    private final StringBuilder buffer = new StringBuilder(0);

    public StandardWebSocketListener(SessionFactory factory, MessageHandler handler) {
        this.factory = factory;
        this.handler = handler;
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.setMaxBinaryMessageBufferSize(0x10000000);
    }

    public void onMessage(String data, boolean last) {
        if (last) {
            if (this.buffer.length() == 0) {
                this.handler.process(data);
            } else {
                this.buffer.append(data);
                String message = this.buffer.toString();
                this.buffer.setLength(0);
                this.handler.process(message);
            }
        } else {
            this.buffer.append(data);
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.factory.close();
        this.buffer.setLength(0);
    }
}

