/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.channel.ChannelFactory;
import io.webfolder.cdp.channel.Connection;
import io.webfolder.cdp.channel.StandardWebSocketChannel;
import io.webfolder.cdp.channel.StandardWebSocketListener;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import java.io.IOException;
import java.net.URI;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class StandardWebSocketFactory
implements ChannelFactory {
    private final WebSocketContainer webSocketContainer;

    public StandardWebSocketFactory(WebSocketContainer webSocketContainer) {
        this.webSocketContainer = webSocketContainer;
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler handler) {
        try {
            StandardWebSocketListener listener = new StandardWebSocketListener(factory, handler);
            Session session = this.webSocketContainer.connectToServer((Endpoint)listener, ClientEndpointConfig.Builder.create().build(), URI.create(connection.getUrl()));
            session.addMessageHandler((javax.websocket.MessageHandler)listener);
            return new StandardWebSocketChannel(session);
        }
        catch (IOException | DeploymentException e) {
            throw new CdpException(e);
        }
    }
}

