/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.CdpLoggerFactory;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import java.io.InputStream;

public class NettyWebSocketListener
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClientHandshaker handshaker;
    private final SessionFactory factory;
    private final MessageHandler handler;
    private ChannelPromise handshakeFuture;
    private final CdpLogger log;

    public NettyWebSocketListener(SessionFactory factory, MessageHandler handler, WebSocketClientHandshaker handshaker) {
        this.factory = factory;
        this.handler = handler;
        this.handshaker = handshaker;
        this.log = new CdpLoggerFactory(factory.getOptions()).getLogger("cdp.netty");
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.factory.close();
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!this.handshaker.isHandshakeComplete()) {
            try {
                this.handshaker.finishHandshake(ctx.channel(), (FullHttpResponse)msg);
                this.handshakeFuture.setSuccess();
            }
            catch (WebSocketHandshakeException e) {
                this.handshakeFuture.setFailure((Throwable)e);
            }
            return;
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame text = (TextWebSocketFrame)frame;
            this.handler.process((InputStream)new ByteBufInputStream(text.content().retain(), true));
        } else if (frame instanceof CloseWebSocketFrame) {
            this.factory.close();
            ctx.channel().close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
        if (!this.factory.closed()) {
            this.log.error(t.getMessage(), t);
        }
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(t);
        }
        ctx.close();
    }
}

