/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.exception.CdpTimeoutException;
import java.net.http.WebSocket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class JreWebSocketChannel
implements Channel {
    private final ReentrantLock lock = new ReentrantLock(true);
    private final CompletableFuture<WebSocket> future;
    private WebSocket webSocket;

    public JreWebSocketChannel(CompletableFuture<WebSocket> future) {
        this.future = future;
    }

    @Override
    public boolean isOpen() {
        return !this.webSocket.isInputClosed() && !this.webSocket.isOutputClosed();
    }

    @Override
    public void disconnect() {
        if (this.isOpen()) {
            this.webSocket.sendClose(1000, "done").thenRun(() -> this.webSocket.abort());
        }
    }

    @Override
    public void sendText(String message) {
        block8: {
            if (!this.webSocket.isInputClosed()) {
                try {
                    if (this.lock.tryLock(5L, TimeUnit.SECONDS)) {
                        this.webSocket.sendText(message, true);
                        break block8;
                    }
                    throw new CdpTimeoutException(message);
                }
                catch (InterruptedException e) {
                    throw new CdpException(e);
                }
                finally {
                    if (this.lock.isLocked()) {
                        this.lock.unlock();
                    }
                }
            }
        }
    }

    @Override
    public void sendText(byte[] message) {
        this.sendText(new String(message, StandardCharsets.UTF_8));
    }

    @Override
    public void connect() {
        this.webSocket = this.future.join();
    }
}

