/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.channel.ChannelFactory;
import io.webfolder.cdp.channel.Connection;
import io.webfolder.cdp.channel.JettyWebSocketChannel;
import io.webfolder.cdp.channel.JettyWebSocketListener;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class JettyWebSocketFactory
implements ChannelFactory,
AutoCloseable {
    private final WebSocketClient client;

    public JettyWebSocketFactory() {
        this.client = new WebSocketClient();
        try {
            this.client.start();
        }
        catch (Exception e) {
            throw new CdpException(e);
        }
    }

    public JettyWebSocketFactory(WebSocketClient client) {
        this.client = client;
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler handler) {
        String url = connection.getUrl();
        CompletableFuture future = null;
        try {
            future = this.client.connect((Object)new JettyWebSocketListener(factory, handler), URI.create(url));
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        return new JettyWebSocketChannel(future);
    }

    @Override
    public void close() {
        if (this.client != null && !this.client.isStopped()) {
            try {
                this.client.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

