/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.Channel;
import jakarta.websocket.CloseReason;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class JakartaWebSocketChannel
implements Channel {
    private final Session session;
    private final RemoteEndpoint.Async remote;

    public JakartaWebSocketChannel(Session session) {
        this.session = session;
        this.remote = session.getAsyncRemote();
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public void disconnect() {
        if (this.session.isOpen()) {
            try {
                this.session.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)1000), "done"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void sendText(String message) {
        this.remote.sendText(message);
    }

    @Override
    public void sendText(byte[] message) {
        this.remote.sendText(new String(message, StandardCharsets.UTF_8));
    }

    @Override
    public void connect() {
    }
}

