/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.Connection;
import io.webfolder.cdp.channel.DevToolsConnection;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.serialization.GsonMapper;
import io.webfolder.cdp.serialization.JsonMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class DevToolsProfileConnection
implements Connection {
    private final Path userProfileDirectory;
    private final JsonMapper mapper;

    public DevToolsProfileConnection(Path userProfileDirectory) {
        this(userProfileDirectory, new GsonMapper());
    }

    public DevToolsProfileConnection(Path userProfileDirectory, JsonMapper mapper) {
        this.userProfileDirectory = userProfileDirectory;
        this.mapper = mapper;
    }

    protected String getHost() {
        return "127.0.0.1";
    }

    @Override
    public String getUrl() {
        Path devToolsActivePort = this.userProfileDirectory.resolve("DevToolsActivePort");
        if (!Files.exists(devToolsActivePort, new LinkOption[0])) {
            throw new CdpException("File not found: " + devToolsActivePort.toString());
        }
        List<Object> lines = Collections.emptyList();
        try {
            lines = Files.readAllLines(devToolsActivePort);
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        if (lines.size() < 2) {
            throw new CdpException("Invalid DevToolsActivePort file.");
        }
        int port = Integer.parseInt((String)lines.get(0));
        String connectionUri = (String)lines.get(1);
        if (!connectionUri.startsWith("/")) {
            throw new CdpException("webSocketDebuggerUrl must start with /");
        }
        String webSocketDebuggerUrl = String.format("ws://%s:%d%s", this.getHost(), port, connectionUri);
        return webSocketDebuggerUrl;
    }

    @Override
    public boolean isValid() {
        String url;
        block4: {
            url = null;
            try {
                url = this.getUrl();
            }
            catch (Throwable t) {
                if (url != null) break block4;
                return false;
            }
        }
        try {
            URI uri = new URI(url);
            DevToolsConnection conn = new DevToolsConnection(uri.getPort(), uri.getHost(), this.mapper);
            return conn.isValid();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

