/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.channel;

import io.webfolder.cdp.channel.AsyncWebSocketChannel;
import io.webfolder.cdp.channel.AsyncWebSocketListener;
import io.webfolder.cdp.channel.Channel;
import io.webfolder.cdp.channel.ChannelFactory;
import io.webfolder.cdp.channel.Connection;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.SessionFactory;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;

public class AsyncWebSocketFactory
implements ChannelFactory,
AutoCloseable {
    private static final int CONNECTION_TIMEOUT = 10000;
    private final AsyncHttpClient client;

    public AsyncWebSocketFactory() {
        this(10000);
    }

    public AsyncWebSocketFactory(int connectionTimeout) {
        this(connectionTimeout, 1, "cdp4j-netty");
    }

    public AsyncWebSocketFactory(int connectionTimeout, int ioThreadsCount, String threadPoolName) {
        DefaultAsyncHttpClientConfig config = new DefaultAsyncHttpClientConfig.Builder().setWebSocketMaxFrameSize(0x10000000).setConnectTimeout(connectionTimeout).setThreadPoolName(threadPoolName).setIoThreadsCount(ioThreadsCount).build();
        this.client = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);
    }

    public AsyncWebSocketFactory(AsyncHttpClient client) {
        this.client = client;
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler messageHandler) {
        String url = connection.getUrl();
        AsyncWebSocketListener messageAdapter = new AsyncWebSocketListener(factory, messageHandler);
        WebSocketUpgradeHandler upgradeHandler = new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)messageAdapter).build();
        CompletableFuture future = this.client.prepareGet(url).execute((AsyncHandler)upgradeHandler).toCompletableFuture();
        AsyncWebSocketChannel channel = new AsyncWebSocketChannel(future);
        return channel;
    }

    @Override
    public void close() {
        if (this.client != null && !this.client.isClosed()) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

