/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoChangeStreamException;
import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.MongoException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import java.util.Arrays;
import java.util.List;

final class ChangeStreamBatchCursorHelper {
    private static final List<Integer> UNRETRYABLE_SERVER_ERROR_CODES = Arrays.asList(136, 237, 11601);

    private ChangeStreamBatchCursorHelper() {
    }

    static boolean isRetryableError(Throwable t) {
        if (!(t instanceof MongoException) || t instanceof MongoChangeStreamException) {
            return false;
        }
        if (t instanceof MongoNotPrimaryException || t instanceof MongoCursorNotFoundException || t instanceof MongoSocketException) {
            return true;
        }
        return !UNRETRYABLE_SERVER_ERROR_CODES.contains(((MongoException)t).getCode());
    }
}

