/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.ReplyHeader;
import com.mongodb.internal.connection.ResponseBuffers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.bson.BsonBinaryReader;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.io.ByteBufferBsonInput;

public class ReplyMessage<T> {
    public static final AtomicLong DECODE_ELAPSED_NS = new AtomicLong(0L);
    private final ReplyHeader replyHeader;
    private final List<T> documents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyMessage(ResponseBuffers responseBuffers, Decoder<T> decoder, long requestId) {
        this(responseBuffers.getReplyHeader(), requestId);
        if (this.replyHeader.getNumberReturned() > 0) {
            long startNS = System.nanoTime();
            ByteBufferBsonInput bsonInput = new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer().duplicate());
            try {
                while (this.documents.size() < this.replyHeader.getNumberReturned()) {
                    try (BsonBinaryReader reader = new BsonBinaryReader(bsonInput);){
                        this.documents.add(decoder.decode(reader, DecoderContext.builder().build()));
                    }
                }
            }
            finally {
                bsonInput.close();
                responseBuffers.reset();
            }
            DECODE_ELAPSED_NS.addAndGet(System.nanoTime() - startNS);
        }
    }

    ReplyMessage(ReplyHeader replyHeader, long requestId) {
        this.replyHeader = replyHeader;
        this.documents = new ArrayList<T>(replyHeader.getNumberReturned());
    }

    public ReplyHeader getReplyHeader() {
        return this.replyHeader;
    }

    public List<T> getDocuments() {
        return this.documents;
    }
}

