/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.changestream;

public enum OperationType {
    INSERT("insert"),
    UPDATE("update"),
    REPLACE("replace"),
    DELETE("delete"),
    INVALIDATE("invalidate");

    private final String value;

    private OperationType(String operationTypeName) {
        this.value = operationTypeName;
    }

    public static OperationType fromString(String operationTypeName) {
        if (operationTypeName != null) {
            for (OperationType operationType : OperationType.values()) {
                if (!operationTypeName.equals(operationType.value)) continue;
                return operationType;
            }
        }
        throw new IllegalArgumentException(String.format("'%s' is not a valid OperationType", operationTypeName));
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "OperationType{value='" + this.value + "'}";
    }
}

