/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataVectorizationSource;
import com.azure.ai.openai.models.OnYourDataVectorizationSourceType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OnYourDataDeploymentNameVectorizationSource
extends OnYourDataVectorizationSource {
    private final String deploymentName;
    private OnYourDataVectorizationSourceType type = OnYourDataVectorizationSourceType.DEPLOYMENT_NAME;
    private Integer dimensions;

    public OnYourDataDeploymentNameVectorizationSource(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    @Override
    public OnYourDataVectorizationSourceType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deployment_name", this.deploymentName);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("dimensions", (Number)this.dimensions);
        return jsonWriter.writeEndObject();
    }

    public static OnYourDataDeploymentNameVectorizationSource fromJson(JsonReader jsonReader) throws IOException {
        return (OnYourDataDeploymentNameVectorizationSource)jsonReader.readObject(reader -> {
            String deploymentName = null;
            OnYourDataVectorizationSourceType type = OnYourDataVectorizationSourceType.DEPLOYMENT_NAME;
            Integer dimensions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deployment_name".equals(fieldName)) {
                    deploymentName = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OnYourDataVectorizationSourceType.fromString(reader.getString());
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    dimensions = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            OnYourDataDeploymentNameVectorizationSource deserializedOnYourDataDeploymentNameVectorizationSource = new OnYourDataDeploymentNameVectorizationSource(deploymentName);
            deserializedOnYourDataDeploymentNameVectorizationSource.type = type;
            deserializedOnYourDataDeploymentNameVectorizationSource.dimensions = dimensions;
            return deserializedOnYourDataDeploymentNameVectorizationSource;
        });
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public OnYourDataDeploymentNameVectorizationSource setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
        return this;
    }
}

