/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureChatExtensionConfiguration;
import com.azure.ai.openai.models.AzureChatExtensionType;
import com.azure.ai.openai.models.MongoDBChatExtensionParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MongoDBChatExtensionConfiguration
extends AzureChatExtensionConfiguration {
    private AzureChatExtensionType type = AzureChatExtensionType.MONGO_DB;
    private final MongoDBChatExtensionParameters parameters;

    public MongoDBChatExtensionConfiguration(MongoDBChatExtensionParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public AzureChatExtensionType getType() {
        return this.type;
    }

    public MongoDBChatExtensionParameters getParameters() {
        return this.parameters;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static MongoDBChatExtensionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDBChatExtensionConfiguration)jsonReader.readObject(reader -> {
            MongoDBChatExtensionParameters parameters = null;
            AzureChatExtensionType type = AzureChatExtensionType.MONGO_DB;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    parameters = MongoDBChatExtensionParameters.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = AzureChatExtensionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            MongoDBChatExtensionConfiguration deserializedMongoDBChatExtensionConfiguration = new MongoDBChatExtensionConfiguration(parameters);
            deserializedMongoDBChatExtensionConfiguration.type = type;
            return deserializedMongoDBChatExtensionConfiguration;
        });
    }
}

