/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ContentFilterCitedDetectionResult;
import com.azure.ai.openai.models.ContentFilterCompletionTextSpanResult;
import com.azure.ai.openai.models.ContentFilterDetailedResults;
import com.azure.ai.openai.models.ContentFilterDetectionResult;
import com.azure.ai.openai.models.ContentFilterResult;
import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContentFilterResultsForChoice
implements JsonSerializable<ContentFilterResultsForChoice> {
    private ContentFilterResult sexual;
    private ContentFilterResult violence;
    private ContentFilterResult hate;
    private ContentFilterResult selfHarm;
    private ContentFilterDetectionResult profanity;
    private ContentFilterDetailedResults customBlocklists;
    private ResponseError error;
    private ContentFilterDetectionResult protectedMaterialText;
    private ContentFilterCitedDetectionResult protectedMaterialCode;
    private ContentFilterCompletionTextSpanResult ungroundedMaterial;

    private ContentFilterResultsForChoice() {
    }

    public ContentFilterResult getSexual() {
        return this.sexual;
    }

    public ContentFilterResult getViolence() {
        return this.violence;
    }

    public ContentFilterResult getHate() {
        return this.hate;
    }

    public ContentFilterResult getSelfHarm() {
        return this.selfHarm;
    }

    public ContentFilterDetectionResult getProfanity() {
        return this.profanity;
    }

    public ContentFilterDetailedResults getCustomBlocklists() {
        return this.customBlocklists;
    }

    public ResponseError getError() {
        return this.error;
    }

    public ContentFilterDetectionResult getProtectedMaterialText() {
        return this.protectedMaterialText;
    }

    public ContentFilterCitedDetectionResult getProtectedMaterialCode() {
        return this.protectedMaterialCode;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sexual", (JsonSerializable)this.sexual);
        jsonWriter.writeJsonField("violence", (JsonSerializable)this.violence);
        jsonWriter.writeJsonField("hate", (JsonSerializable)this.hate);
        jsonWriter.writeJsonField("self_harm", (JsonSerializable)this.selfHarm);
        jsonWriter.writeJsonField("profanity", (JsonSerializable)this.profanity);
        jsonWriter.writeJsonField("custom_blocklists", (JsonSerializable)this.customBlocklists);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeJsonField("protected_material_text", (JsonSerializable)this.protectedMaterialText);
        jsonWriter.writeJsonField("protected_material_code", (JsonSerializable)this.protectedMaterialCode);
        jsonWriter.writeJsonField("ungrounded_material", (JsonSerializable)this.ungroundedMaterial);
        return jsonWriter.writeEndObject();
    }

    public static ContentFilterResultsForChoice fromJson(JsonReader jsonReader) throws IOException {
        return (ContentFilterResultsForChoice)jsonReader.readObject(reader -> {
            ContentFilterResultsForChoice deserializedContentFilterResultsForChoice = new ContentFilterResultsForChoice();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sexual".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.sexual = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("violence".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.violence = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("hate".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.hate = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("self_harm".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.selfHarm = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("profanity".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.profanity = ContentFilterDetectionResult.fromJson(reader);
                    continue;
                }
                if ("custom_blocklists".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.customBlocklists = ContentFilterDetailedResults.fromJson(reader);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.error = ResponseError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("protected_material_text".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.protectedMaterialText = ContentFilterDetectionResult.fromJson(reader);
                    continue;
                }
                if ("protected_material_code".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.protectedMaterialCode = ContentFilterCitedDetectionResult.fromJson(reader);
                    continue;
                }
                if ("ungrounded_material".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.ungroundedMaterial = ContentFilterCompletionTextSpanResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContentFilterResultsForChoice;
        });
    }

    public ContentFilterCompletionTextSpanResult getUngroundedMaterial() {
        return this.ungroundedMaterial;
    }
}

