/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.CompletionsUsageCompletionTokensDetails;
import com.azure.ai.openai.models.CompletionsUsagePromptTokensDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CompletionsUsage
implements JsonSerializable<CompletionsUsage> {
    private final int completionTokens;
    private final int promptTokens;
    private final int totalTokens;
    private CompletionsUsagePromptTokensDetails promptTokensDetails;
    private CompletionsUsageCompletionTokensDetails completionTokensDetails;

    private CompletionsUsage(int completionTokens, int promptTokens, int totalTokens) {
        this.completionTokens = completionTokens;
        this.promptTokens = promptTokens;
        this.totalTokens = totalTokens;
    }

    public int getCompletionTokens() {
        return this.completionTokens;
    }

    public int getPromptTokens() {
        return this.promptTokens;
    }

    public int getTotalTokens() {
        return this.totalTokens;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("completion_tokens", this.completionTokens);
        jsonWriter.writeIntField("prompt_tokens", this.promptTokens);
        jsonWriter.writeIntField("total_tokens", this.totalTokens);
        jsonWriter.writeJsonField("prompt_tokens_details", (JsonSerializable)this.promptTokensDetails);
        jsonWriter.writeJsonField("completion_tokens_details", (JsonSerializable)this.completionTokensDetails);
        return jsonWriter.writeEndObject();
    }

    public static CompletionsUsage fromJson(JsonReader jsonReader) throws IOException {
        return (CompletionsUsage)jsonReader.readObject(reader -> {
            int completionTokens = 0;
            int promptTokens = 0;
            int totalTokens = 0;
            CompletionsUsagePromptTokensDetails promptTokensDetails = null;
            CompletionsUsageCompletionTokensDetails completionTokensDetails = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("completion_tokens".equals(fieldName)) {
                    completionTokens = reader.getInt();
                    continue;
                }
                if ("prompt_tokens".equals(fieldName)) {
                    promptTokens = reader.getInt();
                    continue;
                }
                if ("total_tokens".equals(fieldName)) {
                    totalTokens = reader.getInt();
                    continue;
                }
                if ("prompt_tokens_details".equals(fieldName)) {
                    promptTokensDetails = CompletionsUsagePromptTokensDetails.fromJson(reader);
                    continue;
                }
                if ("completion_tokens_details".equals(fieldName)) {
                    completionTokensDetails = CompletionsUsageCompletionTokensDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            CompletionsUsage deserializedCompletionsUsage = new CompletionsUsage(completionTokens, promptTokens, totalTokens);
            deserializedCompletionsUsage.promptTokensDetails = promptTokensDetails;
            deserializedCompletionsUsage.completionTokensDetails = completionTokensDetails;
            return deserializedCompletionsUsage;
        });
    }

    public CompletionsUsagePromptTokensDetails getPromptTokensDetails() {
        return this.promptTokensDetails;
    }

    public CompletionsUsageCompletionTokensDetails getCompletionTokensDetails() {
        return this.completionTokensDetails;
    }
}

