/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatTokenLogProbabilityInfo;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatTokenLogProbabilityResult
implements JsonSerializable<ChatTokenLogProbabilityResult> {
    private final String token;
    private final double logprob;
    private final List<Integer> bytes;
    private final List<ChatTokenLogProbabilityInfo> topLogprobs;

    private ChatTokenLogProbabilityResult(String token, double logprob, List<Integer> bytes, List<ChatTokenLogProbabilityInfo> topLogprobs) {
        this.token = token;
        this.logprob = logprob;
        this.bytes = bytes;
        this.topLogprobs = topLogprobs;
    }

    public String getToken() {
        return this.token;
    }

    public double getLogprob() {
        return this.logprob;
    }

    public List<Integer> getBytes() {
        return this.bytes;
    }

    public List<ChatTokenLogProbabilityInfo> getTopLogprobs() {
        return this.topLogprobs;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("token", this.token);
        jsonWriter.writeDoubleField("logprob", this.logprob);
        jsonWriter.writeArrayField("bytes", this.bytes, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeArrayField("top_logprobs", this.topLogprobs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ChatTokenLogProbabilityResult fromJson(JsonReader jsonReader) throws IOException {
        return (ChatTokenLogProbabilityResult)jsonReader.readObject(reader -> {
            String token = null;
            double logprob = 0.0;
            List bytes = null;
            List topLogprobs = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("token".equals(fieldName)) {
                    token = reader.getString();
                    continue;
                }
                if ("logprob".equals(fieldName)) {
                    logprob = reader.getDouble();
                    continue;
                }
                if ("bytes".equals(fieldName)) {
                    bytes = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("top_logprobs".equals(fieldName)) {
                    topLogprobs = reader.readArray(reader1 -> ChatTokenLogProbabilityInfo.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new ChatTokenLogProbabilityResult(token, logprob, bytes, topLogprobs);
        });
    }
}

