/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatRequestToolMessage
extends ChatRequestMessage {
    private final BinaryData content;
    private final String stringContent;
    private final List<ChatMessageContentItem> chatMessageContentItem;
    private final String toolCallId;
    private ChatRole role = ChatRole.TOOL;

    public BinaryData getContent() {
        return this.content;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.stringContent != null) {
            jsonWriter.writeStringField("content", this.stringContent);
        } else if (this.chatMessageContentItem != null) {
            jsonWriter.writeArrayField("content", this.chatMessageContentItem, JsonWriter::writeJson);
        }
        jsonWriter.writeStringField("tool_call_id", this.toolCallId);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestToolMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestToolMessage)jsonReader.readObject(reader -> {
            BinaryData content = null;
            String toolCallId = null;
            ChatRole role = ChatRole.TOOL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    if (reader.currentToken() == JsonToken.STRING) {
                        content = BinaryData.fromString((String)reader.getString());
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.START_ARRAY) {
                        content = BinaryData.fromObject((Object)reader.readArray(arrayReader -> (ChatMessageContentItem)arrayReader.readObject(ChatMessageContentItem::fromJson)));
                        continue;
                    }
                    throw new IllegalStateException("Unexpected 'content' type found when deserializing ChatRequestToolMessage JSON object: " + reader.currentToken());
                }
                if ("tool_call_id".equals(fieldName)) {
                    toolCallId = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestToolMessage deserializedChatRequestToolMessage = new ChatRequestToolMessage(content, toolCallId);
            deserializedChatRequestToolMessage.role = role;
            return deserializedChatRequestToolMessage;
        });
    }

    private ChatRequestToolMessage(BinaryData content, String toolCallId) {
        this.content = content;
        this.toolCallId = toolCallId;
        this.stringContent = null;
        this.chatMessageContentItem = null;
    }

    public ChatRequestToolMessage(String content, String toolCallId) {
        this.content = BinaryData.fromString((String)content);
        this.toolCallId = toolCallId;
        this.stringContent = content;
        this.chatMessageContentItem = null;
    }

    public ChatRequestToolMessage(List<ChatMessageContentItem> content, String toolCallId) {
        this.content = BinaryData.fromObject(content);
        this.toolCallId = toolCallId;
        this.stringContent = null;
        this.chatMessageContentItem = content;
    }
}

