/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatRequestAssistantMessage;
import com.azure.ai.openai.models.ChatRequestFunctionMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestToolMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class ChatRequestMessage
implements JsonSerializable<ChatRequestMessage> {
    private ChatRole role = ChatRole.fromString("ChatRequestMessage");

    public ChatRole getRole() {
        return this.role;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestMessage)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ChatRequestMessage chatRequestMessage;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("role".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("system".equals(discriminatorValue)) {
                    chatRequestMessage = ChatRequestSystemMessage.fromJson(readerToUse.reset());
                    return chatRequestMessage;
                }
                if ("user".equals(discriminatorValue)) {
                    chatRequestMessage = ChatRequestUserMessage.fromJson(readerToUse.reset());
                    return chatRequestMessage;
                }
                if ("assistant".equals(discriminatorValue)) {
                    chatRequestMessage = ChatRequestAssistantMessage.fromJson(readerToUse.reset());
                    return chatRequestMessage;
                }
                if ("tool".equals(discriminatorValue)) {
                    chatRequestMessage = ChatRequestToolMessage.fromJson(readerToUse.reset());
                    return chatRequestMessage;
                }
                if ("function".equals(discriminatorValue)) {
                    chatRequestMessage = ChatRequestFunctionMessage.fromJson(readerToUse.reset());
                    return chatRequestMessage;
                }
                chatRequestMessage = ChatRequestMessage.fromJsonKnownDiscriminator(readerToUse.reset());
                return chatRequestMessage;
            }
        });
    }

    static ChatRequestMessage fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ChatRequestMessage)jsonReader.readObject(reader -> {
            ChatRequestMessage deserializedChatRequestMessage = new ChatRequestMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    deserializedChatRequestMessage.role = ChatRole.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChatRequestMessage;
        });
    }
}

