/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ollama.ChatResponse;
import dev.langchain4j.model.ollama.Message;
import dev.langchain4j.model.ollama.OllamaMessagesUtils;
import dev.langchain4j.model.ollama.ToolCall;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class OllamaStreamingResponseBuilder {
    private StringBuffer contentBuilder = new StringBuffer();
    private volatile TokenUsage tokenUsage;
    private volatile List<ToolExecutionRequest> toolExecutionRequests = new CopyOnWriteArrayList<ToolExecutionRequest>();

    OllamaStreamingResponseBuilder() {
    }

    void append(ChatResponse partialResponse) {
        String content;
        Message message;
        if (partialResponse == null) {
            return;
        }
        if (partialResponse.getEvalCount() != null && partialResponse.getPromptEvalCount() != null) {
            this.tokenUsage = new TokenUsage(partialResponse.getPromptEvalCount(), partialResponse.getEvalCount());
        }
        if ((message = partialResponse.getMessage()) == null) {
            return;
        }
        List<ToolCall> toolCalls = message.getToolCalls();
        if (!Utils.isNullOrEmpty(toolCalls)) {
            this.toolExecutionRequests.addAll(OllamaMessagesUtils.toToolExecutionRequests(toolCalls));
        }
        if ((content = message.getContent()) != null) {
            this.contentBuilder.append(content);
        }
    }

    Response<AiMessage> build() {
        if (!Utils.isNullOrEmpty(this.toolExecutionRequests)) {
            return Response.from((Object)AiMessage.from(this.toolExecutionRequests), (TokenUsage)this.tokenUsage);
        }
        String text = this.contentBuilder.toString();
        if (text.isEmpty()) {
            return null;
        }
        return Response.from((Object)AiMessage.from((String)text), (TokenUsage)this.tokenUsage);
    }
}

