/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.mapreduce;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.mongodb.error.OlapBuilderMongoDbErrorCode;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderMongoDbMapReduceData {
    private final String inputCollectionName;
    private final String map;
    private final String reduce;
    private final String outputCollection;
    private final MapReduceCommand.OutputType type;
    @Nullable
    private final DBObject query;

    public OlapBuilderMongoDbMapReduceData(String inputCollectionName, String map, String reduce, String outputCollection, MapReduceCommand.OutputType type, @Nullable DBObject query) {
        this.inputCollectionName = inputCollectionName;
        this.map = map;
        this.reduce = reduce;
        this.outputCollection = outputCollection;
        this.type = type;
        this.query = query;
    }

    public static MapReduceOutput mapReduce(DB mongoDB, DBObject object) {
        if (OlapLoggers.BUILDER_MONGODB.isDebugEnabled()) {
            OlapLoggers.BUILDER_MONGODB.debug((Object)("[MongoDB] mapReduce (json): " + object.toString()));
        }
        OlapBuilderMongoDbMapReduceData data = OlapBuilderMongoDbMapReduceData.create(object);
        DBCollection inputCollection = mongoDB.getCollection(data.inputCollectionName);
        if (inputCollection == null) {
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the mapReduce collection [" + data.inputCollectionName + "] does not exist"});
        }
        MapReduceCommand command = new MapReduceCommand(inputCollection, data.map, data.reduce, data.outputCollection, data.type, data.query);
        String finalize = OlapBuilderMongoDbMapReduceData.asOptionalString(object, "finalize");
        DBObject sort = OlapBuilderMongoDbMapReduceData.asOptionalObject(object, "sort");
        int limit = OlapBuilderMongoDbMapReduceData.asOptionalInteger(object, "limit");
        Map<String, Object> scope = OlapBuilderMongoDbMapReduceData.asOptionalMap(object, "scope");
        Boolean jsMode = OlapBuilderMongoDbMapReduceData.asOptionalBoolean(object, "jsMode");
        Boolean verbose = OlapBuilderMongoDbMapReduceData.asOptionalBoolean(object, "verbose");
        Boolean bypassDocumentValidation = OlapBuilderMongoDbMapReduceData.asOptionalBoolean(object, "bypassDocumentValidation");
        String outputDB = OlapBuilderMongoDbMapReduceData.asOptionalString(object, "db");
        long maxTimeMS = OlapBuilderMongoDbMapReduceData.asOptionalInteger(object, "maxTimeMS");
        command.setFinalize(finalize);
        command.setSort(sort);
        command.setLimit(limit);
        command.setScope(scope);
        command.setJsMode(jsMode);
        if (verbose != null) {
            command.setVerbose(verbose);
        }
        command.setBypassDocumentValidation(bypassDocumentValidation);
        command.setOutputDB(outputDB);
        command.setMaxTime(maxTimeMS, TimeUnit.MILLISECONDS);
        if (OlapLoggers.BUILDER_MONGODB.isDebugEnabled()) {
            OlapLoggers.BUILDER_MONGODB.debug((Object)("[MongoDB] mapReduce ( cmd): " + command.toString()));
        }
        MapReduceOutput res = inputCollection.mapReduce(command);
        return res;
    }

    public static OlapBuilderMongoDbMapReduceData create(DBObject object) {
        String inputCollectionName = OlapBuilderMongoDbMapReduceData.asString(object, "mapReduce");
        String map = OlapBuilderMongoDbMapReduceData.asString(object, "map");
        String reduce = OlapBuilderMongoDbMapReduceData.asString(object, "reduce");
        String outputCollection = OlapBuilderMongoDbMapReduceData.asOutputCollection(object);
        MapReduceCommand.OutputType outputType = OlapBuilderMongoDbMapReduceData.asOutputType(object);
        DBObject query = OlapBuilderMongoDbMapReduceData.asOptionalObject(object, "query");
        return new OlapBuilderMongoDbMapReduceData(inputCollectionName, map, reduce, outputCollection, outputType, query);
    }

    private static String asString(DBObject object, String key) {
        Object value = object.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the [" + key + "] is not specified"});
        }
        throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the [" + key + "] must be a string"});
    }

    @Nullable
    private static String asOptionalString(DBObject object, String key) {
        Object value = object.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the [" + key + "] must be a string"});
    }

    @Nullable
    private static Boolean asOptionalBoolean(DBObject object, String key) {
        Object value = object.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null) {
            return null;
        }
        throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the [" + key + "] must be a boolean"});
    }

    private static int asOptionalInteger(DBObject object, String key) {
        Object value = object.get(key);
        if (value instanceof Long || value instanceof Integer || value instanceof Byte) {
            return (Integer)value;
        }
        if (value == null) {
            return 0;
        }
        throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the [" + key + "] must be a integer"});
    }

    private static MapReduceCommand.OutputType asOutputType(DBObject object) {
        Object out = object.get("out");
        if (out == null) {
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the out option is not specified"});
        }
        if (out instanceof String) {
            return MapReduceCommand.OutputType.REPLACE;
        }
        if (out instanceof DBObject) {
            DBObject dbObject = (DBObject)out;
            if (dbObject.containsField("inline")) {
                return MapReduceCommand.OutputType.INLINE;
            }
            if (dbObject.containsField("replace")) {
                return MapReduceCommand.OutputType.REPLACE;
            }
            if (dbObject.containsField("merge")) {
                return MapReduceCommand.OutputType.MERGE;
            }
            if (dbObject.containsField("reduce")) {
                return MapReduceCommand.OutputType.REDUCE;
            }
        }
        throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the out option is invalid (type)"});
    }

    private static String asOutputCollection(DBObject object) {
        Object out = object.get("out");
        if (out == null) {
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the out option is not specified"});
        }
        if (out instanceof String) {
            return (String)out;
        }
        if (out instanceof DBObject) {
            DBObject dbObject = (DBObject)out;
            if (dbObject.containsField("inline")) {
                return "";
            }
            if (dbObject.containsField("replace")) {
                return OlapBuilderMongoDbMapReduceData.asString(dbObject, "replace");
            }
            if (dbObject.containsField("merge")) {
                return OlapBuilderMongoDbMapReduceData.asString(dbObject, "merge");
            }
            if (dbObject.containsField("reduce")) {
                return OlapBuilderMongoDbMapReduceData.asString(dbObject, "reduce");
            }
        }
        throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the out option is invalid (type)"});
    }

    @Nullable
    private static DBObject asOptionalObject(DBObject object, String key) {
        Object value = object.get(key);
        if (value instanceof DBObject) {
            return (DBObject)value;
        }
        if (value == null) {
            return null;
        }
        throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the [" + key + "] must be a document"});
    }

    @Nullable
    private static Map<String, Object> asOptionalMap(DBObject object, String key) {
        Object value = object.get(key);
        if (value instanceof Map) {
            return (Map)value;
        }
        if (value == null) {
            return null;
        }
        throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"the [" + key + "] must be a document"});
    }

    public String getMap() {
        return this.map;
    }

    public String getReduce() {
        return this.reduce;
    }
}

