/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableColumnBuilder;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbWithCollectionDataTable;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderMongoDbWithPrototypeDataTable
extends OlapBuilderMongoDbWithCollectionDataTable {
    public static final CdProperty PROTOTYPE = new CdReadWriteProperty(OlapBuilderMongoDbWithPrototypeDataTable.class, "jsonPrototype", false){

        public Class<?> getTypeForDefaultEditor() {
            return CdJson.class;
        }
    };
    @XmlAttribute(name="jsonPrototype", required=false)
    @Nullable
    protected String jsonPrototype;

    public OlapBuilderMongoDbWithPrototypeDataTable() {
    }

    public OlapBuilderMongoDbWithPrototypeDataTable(String tableName, String collection, @Nullable String jsonPrototype) {
        super(tableName, collection);
        this.jsonPrototype = jsonPrototype;
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderMongoDbConnection connection, OlapBuilderErrorManager errorManager) {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.jsonPrototype)) {
            return this.discoverAllColumnsFromPrototype();
        }
        Object one = this.findOneForDiscoverColumns(connection);
        return OlapBuilderMongoDbTableColumnBuilder.discoverColumn(one);
    }

    protected List<IOlapBuilderDataColumnDef> discoverAllColumnsFromPrototype() {
        BasicDBObject one = BasicDBObject.parse((String)this.jsonPrototype);
        return OlapBuilderMongoDbTableColumnBuilder.discoverColumn((DBObject)one);
    }

    public String getPrototype() {
        return this.jsonPrototype;
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderMongoDbWithPrototypeDataTable tableUpdate = (OlapBuilderMongoDbWithPrototypeDataTable)newTable;
        return !Objects.equals(this.jsonPrototype, tableUpdate.jsonPrototype);
    }
}

