/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.Cursor;
import com.mongodb.DBObject;
import crazydev.common.collection.CdArrayList;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbDataSource;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbDataTable;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRow;
import java.text.ParseException;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

public abstract class OlapBuilderMongoDbTableRowReaderOld<TABLE extends OlapBuilderMongoDbDataTable>
extends OlapBuilderAbstractTableRowReader<TABLE, OlapBuilderMongoDbConnection> {
    @Nullable
    protected Cursor cursor;
    protected CdArrayList<String[]> columnCache;

    protected OlapBuilderMongoDbTableRowReaderOld(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, TABLE table, String fullNameForEndUser) {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
    }

    public void doInit() {
        this.initConnection();
        this.cursor = this.initCursor();
        this.buildCache(((OlapBuilderMongoDbDataTable)this.table).getAllColumns());
    }

    protected void buildCache(List<IOlapBuilderDataColumnDef> columns) {
        this.columnCache = new CdArrayList();
        for (IOlapBuilderDataColumnDef columnDef : columns) {
            String colName = columnDef.getName();
            String[] names = colName.split("\\.");
            this.columnCache.set(columnDef.getIndex(), (Object)names);
        }
    }

    protected abstract Cursor initCursor();

    public void done() {
        if (this.cursor != null) {
            this.cursor.close();
        }
        super.done();
    }

    public boolean isRowSafe() {
        return true;
    }

    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        if (this.cursor == null) {
            return null;
        }
        if (this.cursor.hasNext()) {
            DBObject document = (DBObject)this.cursor.next();
            return OlapBuilderMongoDbTableRow.create(this, document);
        }
        return null;
    }

    public String[] getColumnSplit(IOlapBuilderDataColumnDef columnDef) {
        return (String[])this.columnCache.get(columnDef.getIndex());
    }

    public boolean applyDateTimeTZtoDate() {
        if (this.table == null) {
            return false;
        }
        OlapBuilderMongoDbDataSource ds = (OlapBuilderMongoDbDataSource)((OlapBuilderMongoDbDataTable)this.table).getDataSource();
        return ds.applyDateTimeTZtoDate();
    }

    @Nullable
    public DateTimeZone getDateTimeTZ() {
        if (this.table == null) {
            return null;
        }
        OlapBuilderMongoDbDataSource ds = (OlapBuilderMongoDbDataSource)((OlapBuilderMongoDbDataTable)this.table).getDataSource();
        return ds.getDateTimeTZ();
    }

    @FunctionalInterface
    public static interface Function {
        public Comparable parse(String var1) throws ParseException;
    }
}

