/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.OlapBuilderAbstractTableRow;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRowReaderOld;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bson.types.BasicBSONList;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class OlapBuilderMongoDbTableRow
extends OlapBuilderAbstractTableRow {
    private static final DateTimeZone UTC = DateTimeZone.UTC;
    private final OlapBuilderMongoDbTableRowReaderOld rowReader;
    private final Object[] values;

    private OlapBuilderMongoDbTableRow(OlapBuilderMongoDbTableRowReaderOld rowReader, Object[] values) {
        this.rowReader = rowReader;
        this.values = values;
    }

    public static OlapBuilderMongoDbTableRow create(OlapBuilderMongoDbTableRowReaderOld rowReader, DBObject document) {
        IOlapBuilderDataTableDef table = rowReader.getTable();
        List columns = table.getAllColumns();
        Object[] values = new Object[columns.size()];
        for (IOlapBuilderDataColumnDef column : columns) {
            if (!column.isSelected()) continue;
            int index = column.getIndex();
            values[index] = OlapBuilderMongoDbTableRow.getValue(rowReader, document, column);
        }
        return new OlapBuilderMongoDbTableRow(rowReader, values);
    }

    @Nullable
    public Object getDataImpl(IOlapBuilderDataColumnDef columnDef) {
        int index = columnDef.getIndex();
        if (index >= 0 && index < this.values.length) {
            return this.values[index];
        }
        throw new RuntimeException("internal error: invalid index [" + index + "] [table:" + this.rowReader.getTableName() + "] [col:" + columnDef.getName() + "] [max:" + this.values.length + "]");
    }

    @Nullable
    private static Object getValue(OlapBuilderMongoDbTableRowReaderOld rowReader, DBObject document, IOlapBuilderDataColumnDef columnDef) {
        String[] names = rowReader.getColumnSplit(columnDef);
        Object value = OlapBuilderMongoDbTableRow.fromObject(columnDef, names, 1, document.get(names[0]));
        if (value != null && columnDef.getType().isString() && columnDef.getDecorationType() != OlapBuilderColumnDecorationType.ARRAY) {
            value = value.toString();
        }
        if (value instanceof Date) {
            DateTimeZone dateTimeTZ = rowReader.getDateTimeTZ();
            boolean applyDateTimeTZtoDate = rowReader.applyDateTimeTZtoDate();
            if (columnDef.getType().equals((Object)OlapBuilderInputType.DATETIME)) {
                value = OlapBuilderMongoDbTableRow.applyTimeZoneProcessing(true, (Date)value, dateTimeTZ);
            } else if (columnDef.getType().equals((Object)OlapBuilderInputType.DATE)) {
                value = applyDateTimeTZtoDate ? OlapBuilderMongoDbTableRow.applyTimeZoneProcessing(false, (Date)value, dateTimeTZ) : OlapBuilderMongoDbTableRow.applyTimeZoneProcessing(false, (Date)value, UTC);
            }
        }
        return value;
    }

    private static Object applyTimeZoneProcessing(boolean dateTime, Date value, @Nullable DateTimeZone dateTimeTZ) {
        if (dateTimeTZ == null) {
            return value;
        }
        long epoch = value.getTime();
        DateTime dt = new DateTime(epoch, dateTimeTZ);
        Object res = dateTime ? dt.toLocalDateTime() : dt.toLocalDate();
        return res;
    }

    @Nullable
    private static Object fromObject(IOlapBuilderDataColumnDef columnDef, String[] names, int startPos, Object rootValue) {
        Object value = rootValue;
        for (int i = startPos; i < names.length; ++i) {
            if (!(value instanceof BasicDBObject)) {
                if (value instanceof BasicBSONList) {
                    value = OlapBuilderMongoDbTableRow.fromList(columnDef, (BasicBSONList)value, names, i);
                    break;
                }
                value = null;
                break;
            }
            value = ((BasicDBObject)value).get(names[i]);
        }
        return value;
    }

    @Nullable
    private static Object fromList(IOlapBuilderDataColumnDef columnDef, BasicBSONList list, String[] names, int nextPos) {
        ArrayList<Object> outList = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object dbItem = list.get(i);
            Object object = OlapBuilderMongoDbTableRow.fromObject(columnDef, names, nextPos, dbItem);
            if (object instanceof ArrayList) {
                outList.addAll((ArrayList)object);
                continue;
            }
            if (object == null) {
                Comparable nullObject;
                if (nextPos < names.length - 1 || (nullObject = columnDef.getNullObject()) == null) continue;
                outList.add(nullObject);
                continue;
            }
            outList.add(object);
        }
        return outList;
    }
}

