/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbHelper;
import java.util.Set;
import org.bson.types.BasicBSONList;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderMongoDbTableProjectionBuilder {
    public static final String MONGODB_ID = "_id";

    public static DBObject getProjection(String kind, @Nullable String doc) {
        DBObject document = OlapBuilderMongoDbHelper.asDBObject(kind, doc);
        StringBuilder projection = new StringBuilder();
        projection.append("{\n");
        if (document != null) {
            Set keys = document.keySet();
            OlapBuilderMongoDbTableProjectionBuilder.handleObjectId(projection, keys);
            for (String key : keys) {
                if (key.equals(MONGODB_ID)) continue;
                Object value = document.get(key);
                OlapBuilderMongoDbTableProjectionBuilder.addKeyValue(projection, key, value, false);
            }
        }
        projection.append("}");
        return OlapBuilderMongoDbHelper.asDBObject(kind, projection.toString());
    }

    private static void handleObjectId(StringBuilder projection, Set<String> keys) {
        boolean hasId = false;
        for (String key : keys) {
            if (!key.equals(MONGODB_ID)) continue;
            hasId = true;
        }
        if (!hasId) {
            projection.append("'").append(MONGODB_ID).append("':0,");
        }
    }

    private static void addKeyValue(StringBuilder projection, String key, Object value, boolean isArray) {
        if (value instanceof BasicDBList) {
            BasicBSONList list = (BasicBSONList)value;
            OlapBuilderMongoDbTableProjectionBuilder.addDBList(projection, key, list);
            return;
        }
        if (value instanceof BasicDBObject) {
            OlapBuilderMongoDbTableProjectionBuilder.addDBObject(projection, key, (BasicDBObject)value, isArray);
            return;
        }
        projection.append("'").append(key).append("':1,");
    }

    private static void addDBList(StringBuilder projection, String parentKey, BasicBSONList list) {
        if (!list.isEmpty()) {
            OlapBuilderMongoDbTableProjectionBuilder.addKeyValue(projection, parentKey, list.get(0), true);
        }
    }

    private static void addDBObject(StringBuilder projection, String parentKey, BasicDBObject value, boolean isArray) {
        for (String key : value.keySet()) {
            OlapBuilderMongoDbTableProjectionBuilder.addKeyValue(projection, parentKey + "." + key, value.get(key), isArray);
        }
    }
}

