/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.DBObject;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderMongoDbTableColumnBuilder {
    public static List<IOlapBuilderDataColumnDef> discoverColumn(@Nullable DBObject document) {
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
        if (document != null) {
            return OlapBuilderMongoDbTableColumnBuilder.discoverColumn(new Document(document.toMap()));
        }
        return columns;
    }

    public static List<IOlapBuilderDataColumnDef> discoverColumn(@Nullable Document document) {
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
        if (document != null) {
            Set keys = document.keySet();
            for (String key : keys) {
                Object value = document.get((Object)key);
                OlapBuilderMongoDbTableColumnBuilder.addKeyValue(columns, key, value, false);
            }
        }
        return columns;
    }

    private static void addKeyValue(List<IOlapBuilderDataColumnDef> columns, String key, Object value, boolean isArray) {
        if (value == null) {
            columns.add(OlapBuilderDataColumn.createStringColumn((String)key));
            return;
        }
        if (value instanceof Map) {
            OlapBuilderMongoDbTableColumnBuilder.addObject(columns, key, (Map)value, isArray);
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                HashSet<IOlapBuilderDataColumnDef> setColumns = new HashSet<IOlapBuilderDataColumnDef>();
                for (Object item : list) {
                    if (item == null) continue;
                    ArrayList<IOlapBuilderDataColumnDef> listColumns = new ArrayList<IOlapBuilderDataColumnDef>();
                    OlapBuilderMongoDbTableColumnBuilder.addKeyValue(listColumns, key, item, true);
                    setColumns.addAll(listColumns);
                }
                columns.addAll(setColumns);
            }
            return;
        }
        OlapBuilderInputType type = OlapBuilderMongoDbTableColumnBuilder.getSimpleType(value);
        columns.add((IOlapBuilderDataColumnDef)new OlapBuilderDataColumn(type, value.getClass().getSimpleName(), key, isArray));
    }

    private static OlapBuilderInputType getSimpleType(Object value) {
        OlapBuilderInputType type = OlapBuilderInputType.STRING;
        if (value instanceof Number) {
            if (value instanceof Integer) {
                type = OlapBuilderInputType.INTEGER;
            } else if (value instanceof Short) {
                type = OlapBuilderInputType.SHORT;
            } else if (value instanceof Long) {
                type = OlapBuilderInputType.LONG;
            } else if (value instanceof Double) {
                type = OlapBuilderInputType.DOUBLE;
            } else if (value instanceof Float) {
                type = OlapBuilderInputType.FLOAT;
            }
        } else if (value instanceof Date) {
            type = OlapBuilderInputType.DATETIME;
        }
        return type;
    }

    private static void addObject(List<IOlapBuilderDataColumnDef> columns, String parentKey, Map<String, Object> value, boolean isArray) {
        for (String key : value.keySet()) {
            OlapBuilderMongoDbTableColumnBuilder.addKeyValue(columns, parentKey + "." + key, value.get(key), isArray);
        }
    }

    static List<? extends IOlapBuilderDataColumnDef> discoverColumn(Object one) {
        if (one instanceof Document) {
            return OlapBuilderMongoDbTableColumnBuilder.discoverColumn((Document)one);
        }
        return OlapBuilderMongoDbTableColumnBuilder.discoverColumn((DBObject)one);
    }
}

