/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdDefaultEnumerableForUi;
import crazydev.common.utils.CdEnumerableForUi;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdLocaleXmlAdapter;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRequestedPartitionKeys;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbHelper;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbDataSource;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.bson.BsonValue;
import org.bson.Document;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderMongoDbDataTable
extends OlapBuilderBaseDataTable<OlapBuilderMongoDbConnection> {
    @XmlJavaTypeAdapter(value=CdLocaleXmlAdapter.class)
    @XmlElement(name="stringConverterLocale", required=false)
    private Locale stringConverterLocale;
    @XmlElement(required=false)
    private String stringDateConverter;

    public OlapBuilderMongoDbDataTable() {
    }

    public OlapBuilderMongoDbDataTable(String tableName) {
        super(tableName);
    }

    public boolean isNameReadOnly() {
        return false;
    }

    protected CdEnumerableForUi getCollectionAsEnumerableForUi(String collection) {
        OlapBuilderMongoDbDataSource dataSource = (OlapBuilderMongoDbDataSource)this.getDataSource();
        if (dataSource == null) {
            return new CdDefaultEnumerableForUi(collection, Arrays.asList(new String[0]));
        }
        List<String> names = dataSource.getCollectionNamesForUi();
        return new CdDefaultEnumerableForUi(collection, names);
    }

    public List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, OlapBuilderMongoDbConnection connection, OlapBuilderErrorManager errorManager) {
        return this.discoverAllColumns(context, (IOlapBuilderConnection)connection, errorManager);
    }

    protected abstract Object findOneForDiscoverColumns(OlapBuilderMongoDbConnection var1);

    public boolean getCacheStringValue() {
        String options = this.getOptions();
        return options != null && options.toUpperCase().contains("CACHESTRINGVALUE");
    }

    @Nullable
    public String getOptions() {
        return null;
    }

    protected List<IOlapBuilderTablePartitionKey> doGetPartitionKeys(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, @Nullable OlapBuilderTableRequestedPartitionKeys requestedPartitions) {
        OlapBuilderMongoDbConnection connection = (OlapBuilderMongoDbConnection)connectionPool.getOrCreateOpenedConnection(context.asRuntimeContext(), (IOlapBuilderDataSource)this.getDataSource());
        MongoDatabase bd = connection.getMongoDataBase();
        MongoCollection collection = bd.getCollection(this.getCollection());
        ArrayList<IOlapBuilderTablePartitionKey> values = new ArrayList<IOlapBuilderTablePartitionKey>();
        this.getDistinct((MongoCollection<Document>)collection).forEach(bsonValue -> {
            OlapBuilderInputType type = OlapBuilderMongoDbHelper.toType(bsonValue);
            Comparable value = OlapBuilderMongoDbHelper.toValue(type, bsonValue);
            String asString = type.getTypeConverter().toStringForPartitionKey((Object)value);
            if (requestedPartitions == null || requestedPartitions.getKeys().indexOf(asString) != -1) {
                if (bsonValue == null) {
                    throw new OlapBuilderErrorException(OlapBuilderErrorCode.PARTITION_KEY_NULL_NOT_SUPPORTED, new Serializable[]{this.getUnderlyingTables(), this.getPartitioningColumnName()});
                }
                values.add((IOlapBuilderTablePartitionKey)new PartitionKey(type, asString, (BsonValue)bsonValue));
            }
        });
        return values;
    }

    protected DistinctIterable<BsonValue> getDistinct(MongoCollection<Document> collection) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    protected String getCollection() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Nullable
    protected String addMarkers(String statement, @Nullable Comparable incrLoadMarker, @Nullable Object partitionValue) {
        if (CdStringUtils.isNullOrBlank((String)statement)) {
            return null;
        }
        String json = this.replaceAll(statement, "$ic3incrValue", incrLoadMarker);
        json = this.replaceAll(json, "$ic3partitionValue", partitionValue);
        return json;
    }

    private String replaceAll(String statement, String tag, @Nullable Object value) {
        if (value == null) {
            return statement;
        }
        String regexp = Matcher.quoteReplacement(tag);
        String valueAsString = value.toString();
        return statement.replaceAll(regexp, valueAsString);
    }

    static class PartitionKey
    extends OlapBuilderAbstractTablePartitionKey {
        private BsonValue bsonValue;

        public PartitionKey(OlapBuilderInputType type, String asString, BsonValue bsonValue) {
            super(type, asString);
            this.bsonValue = bsonValue;
        }
    }
}

