/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.aggregate;

import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.aggregate.OlapBuilderMongoDbAggregateDataTableValidator;
import crazydev.iccube.builder.mongodb.datatable.aggregate.OlapBuilderMongoDbAggregateTableRowReader;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbWithPrototypeDataTable;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;
import org.bson.BsonValue;
import org.bson.Document;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="mongoDB-aggregate")
public class OlapBuilderMongoDbAggregateDataTable
extends OlapBuilderMongoDbWithPrototypeDataTable {
    public static final CdProperty PIPELINE = new CdReadWriteProperty(OlapBuilderMongoDbAggregateDataTable.class, "pipeline", true){

        public Class<?> getTypeForDefaultEditor() {
            return CdJson.class;
        }
    };
    public static final CdProperty PIPELINE_INCR_LOAD = new CdReadWriteProperty(OlapBuilderMongoDbAggregateDataTable.class, "pipelineIncrLoad", false){

        public boolean isForIncrLoad() {
            return true;
        }

        public boolean isForPartitioning() {
            return true;
        }

        public Class<?> getTypeForDefaultEditor() {
            return CdJson.class;
        }
    };
    public static final CdProperty ALLOW_DISK_USE = new CdReadWriteProperty("group.dataSourceAdvanced", OlapBuilderMongoDbAggregateDataTable.class, "allowDiskUse", false);
    public static final CdProperty BATCH_SIZE = new CdReadWriteProperty("group.dataSourceAdvanced", OlapBuilderMongoDbAggregateDataTable.class, "batchSize", false);
    public static final CdProperty OPTIONS = new CdReadWriteProperty("group.dataSourceAdvanced", OlapBuilderMongoDbAggregateDataTable.class, "options", false);
    public static final CdProperty PARTITIONFIELD = new CdReadWriteProperty(OlapBuilderMongoDbAggregateDataTable.class, "partitionField", false){

        public boolean isForPartitioning() {
            return true;
        }
    };
    @XmlAttribute(name="allowDiskUse", required=false)
    @Nullable
    protected Boolean allowDiskUse;
    @XmlAttribute(name="batchSize", required=false)
    @Nullable
    protected Integer batchSize;
    @XmlElement(name="pipeline", required=true)
    private String pipeline;
    @XmlAttribute(name="partitionField", required=false)
    private String partitionField;
    @XmlElement(name="pipelineIncrLoad", required=false)
    private String pipelineIncrLoad;
    @XmlAttribute(name="options", required=false)
    private String options;

    public OlapBuilderMongoDbAggregateDataTable() {
    }

    public OlapBuilderMongoDbAggregateDataTable(String name, String collection, @Nullable String jsonPrototype, String pipeline, @Nullable Boolean allowDiskUse, @Nullable Integer batchSize) {
        super(name, collection, jsonPrototype);
        this.pipeline = pipeline;
        this.allowDiskUse = allowDiskUse;
        this.batchSize = batchSize;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    @Nullable
    public String getPipelineIncrLoad(@Nullable Comparable incrLoadMarker, @Nullable Object partitionValue) {
        String json = this.addMarkers(this.pipelineIncrLoad, incrLoadMarker, partitionValue);
        return json;
    }

    @Nullable
    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    public String getInternalFriendlyTypeName() {
        return "MongoDB Aggregate Table";
    }

    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderMongoDbConnection>, IOlapBuilderDataTableDef<OlapBuilderMongoDbConnection>> getValidator() {
        return new OlapBuilderMongoDbAggregateDataTableValidator();
    }

    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderMongoDbAggregateTableRowReader(context, connectionPool, maxRowCount, this, "MongoDB " + this.getName() + ".aggregate()", null);
    }

    public boolean hasTablePartitioning() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.partitionField);
    }

    @Nullable
    public String getPartitioningColumnName() {
        return this.partitionField;
    }

    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreatePartitionTableRowReaders(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, IOlapBuilderTablePartitionKey partitionKey) {
        return new OlapBuilderMongoDbAggregateTableRowReader(context, connectionPool, -1, this, "MongoDB " + this.getName() + ".find()", partitionKey);
    }

    @Override
    protected Object findOneForDiscoverColumns(OlapBuilderMongoDbConnection connection) {
        return OlapBuilderMongoDbAggregateTableRowReader.first(connection, this);
    }

    @Override
    @Nullable
    public String getOptions() {
        return this.options;
    }

    public boolean hasQueryIncrLoadPart() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.pipelineIncrLoad);
    }

    @Override
    protected DistinctIterable<BsonValue> getDistinct(MongoCollection<Document> collection) {
        return collection.distinct(this.getPartitioningColumnName(), BsonValue.class);
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderMongoDbAggregateDataTable tableUpdate = (OlapBuilderMongoDbAggregateDataTable)newTable;
        return !Objects.equals(this.pipeline, tableUpdate.pipeline);
    }
}

