/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datasource;

import com.mongodb.ConnectionString;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.validation.OlapBuilderBaseDataSourceValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbHelper;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbDataSource;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderMongoDbDataSourceValidator
extends OlapBuilderBaseDataSourceValidator {
    protected void doValidateFields(OlapBuilderValidationContext context, IOlapBuilderDataSource dataSource) {
        super.doValidateFields(context, dataSource);
        OlapBuilderMongoDbDataSource myDataSource = (OlapBuilderMongoDbDataSource)dataSource;
        this.validateNotBlankField(context, OlapBuilderMongoDbDataSource.PASSWORD, myDataSource.getDbName());
        String connectionString = myDataSource.getDecodedConnectionString();
        if (CdStringUtils.isNotNullAndNotBlank((String)connectionString)) {
            OlapBuilderMongoDbDataSourceValidator.validateConnectionString((OlapBuilderErrorManager)context.getErrorManager(), connectionString);
        } else {
            this.validateNotBlankField(context, OlapBuilderMongoDbDataSource.SERVER_NAME, myDataSource.getServerName());
            this.validateNotBlankField(context, OlapBuilderMongoDbDataSource.DB_NAME, myDataSource.getDbName());
            try {
                ((OlapBuilderMongoDbDataSource)dataSource).getDateTimeTZ();
            }
            catch (OlapBuilderErrorException ex) {
                context.addError(OlapBuilderMongoDbDataSource.DATE_TIME_TZ, (CdErrorCode)OlapBuilderErrorCode.TIMEZONE_INVALID, new Serializable[]{OlapBuilderMongoDbDataSource.DATE_TIME_TZ.getName()});
            }
            OlapBuilderMongoDbHelper.validate(myDataSource.getProperties());
        }
    }

    static void validateConnectionString(OlapBuilderErrorManager errorManager, @Nullable String connectionString) {
        try {
            if (connectionString == null) {
                errorManager.addError(OlapBuilderMongoDbDataSource.CONNECTIONSTRING, (CdErrorCode)OlapBuilderErrorCode.FIELD_IS_NULL, new Serializable[]{OlapBuilderMongoDbDataSource.CONNECTIONSTRING.getName()});
                return;
            }
            if (StringUtils.isBlank((CharSequence)connectionString)) {
                errorManager.addError(OlapBuilderMongoDbDataSource.CONNECTIONSTRING, (CdErrorCode)OlapBuilderErrorCode.FIELD_IS_EMPTY, new Serializable[]{OlapBuilderMongoDbDataSource.CONNECTIONSTRING.getName()});
                return;
            }
            new ConnectionString(connectionString);
        }
        catch (RuntimeException ex) {
            errorManager.addError(OlapBuilderMongoDbDataSource.CONNECTIONSTRING, (CdErrorCode)OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex.getLocalizedMessage()});
        }
    }
}

