/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.common;

import com.iccube.bson.decoder.ic3BsonDateTimeDecoder;
import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.mongodb.MongoClientSettings;
import com.mongodb.util.JSON;
import crazydev.common.exception.programming.CdUnsupportedSwitchTypeException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbLoggers;
import crazydev.iccube.builder.mongodb.error.OlapBuilderMongoDbErrorCode;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderMongoDbHelper {
    public static final String CLUSTER_SERVER_SELECTION_TIMEOUT = "cluster.serverSelectionTimeout";
    private static final Map<String, BiConsumer<MongoClientSettings.Builder, Integer>> options = new HashMap<String, BiConsumer<MongoClientSettings.Builder, Integer>>();

    public static void applySettings(MongoClientSettings.Builder builder, String name, int value) {
        options.get(name).accept(builder, value);
    }

    public static String getDefaultSetting() {
        StringBuilder defaultOptions = new StringBuilder();
        defaultOptions.append("# All times in milliseconds and 0 for false\n");
        defaultOptions.append("\n");
        options.keySet().stream().sorted().forEach(s -> {
            if (s.equals(CLUSTER_SERVER_SELECTION_TIMEOUT)) {
                defaultOptions.append((String)s).append(" =  5000").append("\n");
            } else {
                defaultOptions.append("# ").append((String)s).append(" =").append("\n");
            }
        });
        return defaultOptions.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validate(@Nullable String properties) {
        if (CdStringUtils.isNullOrBlank((String)properties)) {
            return;
        }
        try {
            Properties asProperties = new Properties();
            asProperties.load(new StringReader(properties));
            for (Map.Entry<Object, Object> entry : asProperties.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                BiConsumer<MongoClientSettings.Builder, Integer> method = options.get(name);
                if (method == null) {
                    throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"unknown connection option [" + name + "]"});
                }
                try {
                    Integer.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"option [" + name + "] value has to be an integer [" + value + "]"});
                    return;
                }
            }
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BUILDER.error((Object)"MongoDB connection options error", (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    @Nullable
    public static DBObject asDBObject(String kind, @Nullable String value) {
        String json;
        String string = json = CdStringUtils.isNotNullAndNotBlank((String)value) ? value : null;
        if (json == null) {
            return null;
        }
        try {
            Object bson = JSON.parse((String)value);
            return (DBObject)bson;
        }
        catch (RuntimeException ex) {
            OlapBuilderMongoDbLoggers.GENERAL.error((Object)("[MongoDB] unexpected JSON (" + kind + ") error"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.JSON_ERROR, new Serializable[]{kind, ex.getMessage()});
        }
    }

    public static List<DBObject> asDBObjectList(String kind, @Nullable String value) {
        String json;
        String string = json = CdStringUtils.isNotNullAndNotBlank((String)value) ? value : null;
        if (json == null) {
            return new ArrayList<DBObject>();
        }
        if (!((String)(value = ((String)value).trim())).startsWith("[")) {
            value = "[" + (String)value;
        }
        if (!((String)value).endsWith("]")) {
            value = (String)value + "]";
        }
        try {
            Object bson = JSON.parse((String)value);
            if (bson instanceof BasicDBList) {
                BasicDBList items = (BasicDBList)bson;
                ArrayList<DBObject> result = new ArrayList<DBObject>();
                for (Object item : items) {
                    if (item instanceof DBObject) {
                        result.add((DBObject)item);
                        continue;
                    }
                    throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.JSON_ERROR, new Serializable[]{kind, "not an array of objects"});
                }
                return result;
            }
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.JSON_ERROR, new Serializable[]{kind, "not an array of objects"});
        }
        catch (RuntimeException ex) {
            OlapBuilderMongoDbLoggers.GENERAL.error((Object)("[MongoDB] unexpected JSON (" + kind + ") error"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.JSON_ERROR, new Serializable[]{kind, ex.getMessage()});
        }
    }

    public static OlapBuilderInputType toType(BsonValue value) {
        if (value == null) {
            return null;
        }
        return switch (value.getBsonType()) {
            case BsonType.DOUBLE -> OlapBuilderInputType.DOUBLE;
            case BsonType.STRING -> OlapBuilderInputType.STRING;
            case BsonType.BOOLEAN -> OlapBuilderInputType.BOOLEAN;
            case BsonType.TIMESTAMP -> OlapBuilderInputType.LONG;
            case BsonType.DATE_TIME -> OlapBuilderInputType.DATETIME;
            case BsonType.NULL -> OlapBuilderInputType.STRING;
            case BsonType.INT32 -> OlapBuilderInputType.INTEGER;
            case BsonType.INT64 -> OlapBuilderInputType.LONG;
            case BsonType.DECIMAL128 -> OlapBuilderInputType.DOUBLE;
            default -> null;
        };
    }

    public static Comparable toValue(OlapBuilderInputType type, BsonValue value) {
        if (value == null) {
            return null;
        }
        return switch (type) {
            case OlapBuilderInputType.DOUBLE -> value.asDouble().doubleValue();
            case OlapBuilderInputType.INTEGER -> value.asInt32().intValue();
            case OlapBuilderInputType.STRING -> value.asString().getValue();
            case OlapBuilderInputType.DATETIME, OlapBuilderInputType.DATE -> ic3BsonDateTimeDecoder.toJodaDateTime(value.asDateTime().getValue());
            case OlapBuilderInputType.BOOLEAN -> value.asBoolean().getValue();
            case OlapBuilderInputType.FLOAT -> value.asDouble().doubleValue();
            case OlapBuilderInputType.SHORT -> value.asInt32().intValue();
            case OlapBuilderInputType.LONG -> value.asInt64().longValue();
            case OlapBuilderInputType.UPPERCASE_STRING -> value.asString().getValue().toUpperCase();
            default -> throw new CdUnsupportedSwitchTypeException((Enum)type);
        };
    }

    static {
        options.put(CLUSTER_SERVER_SELECTION_TIMEOUT, (builder, value) -> builder.applyToClusterSettings(builder1 -> builder1.serverSelectionTimeout((long)value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("cluster.localThreshold", (builder, value) -> builder.applyToClusterSettings(builder1 -> builder1.localThreshold((long)value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("cluster.maxWaitQueueSize", (builder, value) -> builder.applyToClusterSettings(builder1 -> builder1.maxWaitQueueSize(value.intValue())));
        options.put("pool.maxSize", (builder, value) -> builder.applyToConnectionPoolSettings(builder1 -> builder1.maxSize(value.intValue())));
        options.put("pool.maintenanceFrequency", (builder, value) -> builder.applyToConnectionPoolSettings(builder1 -> builder1.maintenanceFrequency((long)value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("pool.maintenanceInitialDelay", (builder, value) -> builder.applyToConnectionPoolSettings(builder1 -> builder1.maintenanceInitialDelay((long)value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("pool.maxConnectionIdleTime", (builder, value) -> builder.applyToConnectionPoolSettings(builder1 -> builder1.maxConnectionIdleTime((long)value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("pool.maxConnectionLifeTime", (builder, value) -> builder.applyToConnectionPoolSettings(builder1 -> builder1.maxConnectionLifeTime((long)value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("pool.maxWaitQueueSize", (builder, value) -> builder.applyToConnectionPoolSettings(builder1 -> builder1.maxWaitQueueSize(value.intValue())));
        options.put("pool.maxWaitTime", (builder, value) -> builder.applyToConnectionPoolSettings(builder1 -> builder1.maxWaitTime((long)value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("pool.minSize", (builder, value) -> builder.applyToConnectionPoolSettings(builder1 -> builder1.minSize(value.intValue())));
        options.put("socket.connectTimeout", (builder, value) -> builder.applyToSocketSettings(builder1 -> builder1.connectTimeout(value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("socket.readTimeout", (builder, value) -> builder.applyToSocketSettings(builder1 -> builder1.readTimeout(value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("socket.receiveBufferSize", (builder, value) -> builder.applyToSocketSettings(builder1 -> builder1.receiveBufferSize(value.intValue())));
        options.put("socket.sendBufferSize", (builder, value) -> builder.applyToSocketSettings(builder1 -> builder1.sendBufferSize(value.intValue())));
        options.put("server.heartbeatFrequency", (builder, value) -> builder.applyToServerSettings(builder1 -> builder1.heartbeatFrequency((long)value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("server.minHeartbeatFrequency", (builder, value) -> builder.applyToServerSettings(builder1 -> builder1.minHeartbeatFrequency((long)value.intValue(), TimeUnit.MILLISECONDS)));
        options.put("ssl.enabled", (builder, value) -> builder.applyToSslSettings(builder1 -> builder1.enabled(value != null && value != 0)));
        options.put("ssl.invalidHostNameAllowed", (builder, value) -> builder.applyToSslSettings(builder1 -> builder1.invalidHostNameAllowed(value != null && value != 0)));
    }
}

