/*
 * Decompiled with CFR 0.152.
 */
package com.iccube.bson;

import java.util.Map;
import org.bson.ByteBuf;
import org.bson.io.ByteBufferBsonInput;
import org.jetbrains.annotations.Nullable;

class ic3BsonStringBuilder {
    @Nullable
    private final byte[] bytes;
    private final int size;
    private final int hash;
    private int start;

    private ic3BsonStringBuilder(byte[] bytes, int start, int size, int hash) {
        this.start = start;
        this.bytes = bytes;
        this.size = size;
        this.hash = hash;
    }

    static StringAndLength getOrCreateString(Map<ic3BsonStringBuilder, String> cache, byte[] buffer, int start) {
        byte bb;
        int hash = 1;
        int pos = start;
        while ((bb = buffer[pos++]) != 0) {
            hash = 31 * hash + bb;
        }
        int size = pos - start - 1;
        if (size == 1) {
            byte asciiByte = buffer[start];
            if (asciiByte < 0) {
                return new StringAndLength(ByteBufferBsonInput.UTF8_CHARSET.newDecoder().replacement(), 2);
            }
            return new StringAndLength(ByteBufferBsonInput.ONE_BYTE_ASCII_STRINGS[asciiByte], 2);
        }
        ic3BsonStringBuilder cStr = new ic3BsonStringBuilder(buffer, start, size, hash);
        String str = cache.computeIfAbsent(cStr, key -> new String(buffer, start, size, ByteBufferBsonInput.UTF8_CHARSET));
        return new StringAndLength(str, size);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ic3BsonStringBuilder obj_ = (ic3BsonStringBuilder)obj;
        if (this.size != obj_.size) {
            return false;
        }
        if (this.bytes != null && obj_.bytes != null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.bytes[this.start + i] == obj_.bytes[obj_.start + i]) continue;
                return false;
            }
            return true;
        }
        throw new RuntimeException("internal error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean equals(ByteBuf buffer, byte[] bytes) {
        int mark = buffer.position() - bytes.length;
        try {
            buffer.position(mark);
            for (int ii = 0; ii < bytes.length; ++ii) {
                if (buffer.get() == bytes[ii]) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            buffer.position(mark + bytes.length);
        }
    }

    static final class StringAndLength {
        final String str;
        final int bytesLength;

        StringAndLength(String str, int bytesLength) {
            this.bytesLength = bytesLength;
            this.str = str;
        }
    }
}

