/*
 * Decompiled with CFR 0.152.
 */
package com.iccube.bson;

import com.iccube.bson.decoder.ic3BsonObjectBuilder;
import com.iccube.bson.ic3BsonRow;
import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdTreeNode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.type.IOlapBuilderInputTypeConverter;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ic3BsonRowBuilder
extends CdTreeNode<String, ic3BsonRowBuilder>
implements ic3BsonObjectBuilder {
    @NotNull
    private final Comparable[] rowValues;
    private IOlapBuilderDataColumnDef col;
    @NotNull
    private IOlapBuilderInputTypeConverter typeConverter;
    private boolean isArray;

    public ic3BsonRowBuilder() {
        this.rowValues = null;
    }

    public ic3BsonRowBuilder(Comparable[] rowValues) {
        super(null, null);
        this.rowValues = rowValues;
    }

    private ic3BsonRowBuilder(ic3BsonRowBuilder root, String child) {
        super((Object)child, (CdTreeNode)root);
        this.rowValues = root.rowValues;
    }

    @Override
    @Nullable
    public ic3BsonRowBuilder getForChild(String documentFieldName) {
        return (ic3BsonRowBuilder)this.getChild(documentFieldName);
    }

    @Override
    public void setValue(String fieldName, Comparable value) {
        Comparable convertedValue;
        if (this.col == null || !this.col.isSelected()) {
            return;
        }
        if (value == null) {
            convertedValue = null;
        } else if (this.isArray) {
            CdComparableArray notConverted = (CdComparableArray)value;
            notConverted = notConverted.expandNestedArrays();
            notConverted.forEachUpdate(v -> v == null ? null : this.typeConverter.toJavaNativeValue(this.col.getName(), v));
            convertedValue = notConverted;
        } else {
            convertedValue = this.typeConverter.toJavaNativeValue(this.col.getName(), (Object)value);
        }
        this.rowValues[this.col.getIndex()] = convertedValue;
    }

    public ic3BsonRow getResult() {
        Comparable[] values = new Comparable[this.rowValues.length];
        System.arraycopy(this.rowValues, 0, values, 0, this.rowValues.length);
        Arrays.fill(this.rowValues, null);
        return new ic3BsonRow(values);
    }

    @NotNull
    protected ic3BsonRowBuilder createChildNode(String child) {
        return new ic3BsonRowBuilder(this, child);
    }

    public void setIndex(IOlapBuilderDataColumnDef col) {
        this.col = col;
        this.typeConverter = col.getType().getTypeConverter();
        this.isArray = col.isArray();
    }
}

