/*
 * Decompiled with CFR 0.152.
 */
package com.iccube.bson;

import com.iccube.bson.decoder.ic3BsonDocumentDecoder;
import com.iccube.bson.ic3BsonBytesBuffer;
import com.iccube.bson.ic3BsonRow;
import com.iccube.bson.ic3BsonRowBuilder;
import com.iccube.bson.ic3BsonStringBuilder;
import crazydev.iccube.configuration.component.properties.OlapProcessingFactsMode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class ic3BsonCodec
implements Codec {
    private final boolean cacheStringValues;
    private final OlapProcessingFactsMode mode;
    private Map<ic3BsonStringBuilder, String> cache = new ConcurrentHashMap<ic3BsonStringBuilder, String>();
    private ic3BsonRowBuilder rowBuilder;

    public ic3BsonCodec(ic3BsonRowBuilder rowBuilder, boolean cacheStringValues, OlapProcessingFactsMode mode) {
        this.rowBuilder = rowBuilder;
        this.cacheStringValues = cacheStringValues;
        this.mode = mode;
    }

    public Object decode(BsonReader reader, DecoderContext decoderContext) {
        byte[] bytes = reader.readValueAsBytes();
        return this.decode(bytes);
    }

    ic3BsonRow decode(byte[] bytes) {
        if (this.mode == OlapProcessingFactsMode.NONE) {
            return new ic3BsonRow();
        }
        ic3BsonBytesBuffer array = new ic3BsonBytesBuffer(this.cache, bytes, this.cacheStringValues);
        ic3BsonDocumentDecoder.decodeContent(array, this.rowBuilder);
        return this.getResult(this.rowBuilder, bytes);
    }

    protected ic3BsonRow getResult(ic3BsonRowBuilder rowBuilder, byte[] bytes) {
        return rowBuilder.getResult();
    }

    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
        throw new RuntimeException();
    }

    public Class getEncoderClass() {
        return ic3BsonRow.class;
    }
}

