/*
 * Decompiled with CFR 0.152.
 */
package com.iccube.bson.decoder;

import com.iccube.bson.decoder.ic3BsonDecoder;
import com.iccube.bson.decoder.ic3BsonObjectBuilder;
import com.iccube.bson.ic3BsonBytesBuffer;
import org.joda.time.Chronology;
import org.joda.time.LocalDateTime;
import org.joda.time.chrono.ISOChronology;

public class ic3BsonDateTimeDecoder
implements ic3BsonDecoder {
    static final Chronology UTC_CHRONOLOGY = ISOChronology.getInstanceUTC();

    @Override
    public void skipValue(ic3BsonBytesBuffer array) {
        array.skip(8);
    }

    @Override
    public void decodeValue(ic3BsonBytesBuffer array, ic3BsonObjectBuilder rowBuilder, String fieldName) {
        long millis = array.getLong();
        LocalDateTime dateTime = ic3BsonDateTimeDecoder.toJodaDateTime(millis);
        rowBuilder.setValue(fieldName, (Comparable)dateTime);
    }

    public static LocalDateTime toJodaDateTime(long millis) {
        LocalDateTime localDateTime = new LocalDateTime(millis, UTC_CHRONOLOGY);
        return localDateTime;
    }
}

