/*
 * Decompiled with CFR 0.152.
 */
package com.iccube.bson.decoder;

import com.iccube.bson.decoder.ic3BsonDecoder;
import com.iccube.bson.decoder.ic3BsonObjectBuilder;
import com.iccube.bson.ic3BsonBytesBuffer;
import com.iccube.bson.ic3BsonType;
import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdComparableArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ic3BsonArrayDecoder
implements ic3BsonDecoder {
    @Override
    public void skipValue(ic3BsonBytesBuffer array) {
        int size = array.getInt() - 4;
        array.skip(size);
    }

    @Override
    public void decodeValue(ic3BsonBytesBuffer array, ic3BsonObjectBuilder rowBuilder, String fieldName) {
        ic3BsonType type;
        array.skip(4);
        ArrayBuilder arrayBuilder = new ArrayBuilder(fieldName);
        while ((type = array.getType()) != ic3BsonType.END_OF_DOCUMENT) {
            array.skipFieldName();
            if (type.isContainer()) {
                type.getDecoder().decodeValue(array, arrayBuilder, "_");
                continue;
            }
            ic3BsonDecoder decoder = type.getDecoder();
            decoder.decodeValue(array, arrayBuilder, "_");
        }
        arrayBuilder.setValues(rowBuilder);
    }

    private static class ArrayBuilder
    implements ic3BsonObjectBuilder {
        private String fieldName;
        private ArrayList<Comparable> list = new ArrayList();
        private Map<String, ArrayBuilder> el = new HashMap<String, ArrayBuilder>();

        public ArrayBuilder(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public ic3BsonObjectBuilder getForChild(String fieldName) {
            return this.el.computeIfAbsent(fieldName, k -> new ArrayBuilder(fieldName));
        }

        @Override
        public void setValue(String fieldName, Comparable value) {
            this.list.add(value);
        }

        public void setValues(ic3BsonObjectBuilder rowBuilder) {
            if (!CdCollections.emptyOrWithNulls(this.list)) {
                rowBuilder.setValue(this.fieldName, (Comparable)new CdComparableArray(this.list.toArray(new Comparable[0])));
            }
            this.el.forEach((childName, builder) -> {
                ic3BsonObjectBuilder rb = rowBuilder.getForChild((String)childName);
                if (rb != null) {
                    builder.setValues(rb);
                }
            });
        }
    }
}

