/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.tableAggregator;

import crazydev.iccube.cluster.node.facts.IFactTableContext;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregator;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregatorFactory;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactsTableRow;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SumDoubleRows
implements IOlapFactTableAggregatorFactory {
    public IOlapFactTableAggregator newInstance() {
        return new IOlapFactTableAggregator(this){
            private boolean isInDebugMode;
            private String debugInfo;
            private List<Integer> positions;
            private double sum;
            {
                Objects.requireNonNull(this$0);
                this.debugInfo = "";
                this.sum = 0.0;
            }

            public String getName() {
                return "Test";
            }

            public void init(IFactTableContext context, String measureName, String factColumnName) {
                this.isInDebugMode = context.isDebug();
                this.sum = 0.0;
                this.positions = Arrays.stream(context.getAllColumns()).filter(c -> c != null && c.getFactDataType().isFloatDouble()).map(c -> context.getFromColumnName(c.getId().getFactColumnName())).toList();
                if (this.isInDebugMode && !this.positions.isEmpty()) {
                    this.debugInfo = Arrays.stream(context.getAllColumns()).filter(c -> c != null && c.getFactDataType().isFloatDouble()).map(c -> c.getId().getFactColumnName()).collect(Collectors.joining("\t")) + "\n";
                }
            }

            public boolean onRow(int rowNumber, IOlapFactsTableRow row) {
                int size = this.positions.size();
                for (int i = 0; i < size; ++i) {
                    Integer colIdx = this.positions.get(i);
                    Double aDouble = row.getAsDouble(colIdx.intValue());
                    if (aDouble != null) {
                        this.sum += aDouble.doubleValue();
                    }
                    if (!this.isInDebugMode) continue;
                    this.debugInfo = this.debugInfo + this.sum + (i >= size - 1 ? "" : "\t");
                }
                if (this.isInDebugMode && !this.positions.isEmpty()) {
                    this.debugInfo = this.debugInfo + "\n";
                }
                return true;
            }

            public OlapScalarEntity asScalarEntity() {
                if (this.isInDebugMode) {
                    return new OlapStringEntity(this.debugInfo);
                }
                return new OlapNumericEntity(this.sum);
            }
        };
    }
}

