/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.plugin.olapfunctions.timedimension.OlapTimeDimensionWith;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapTimeDimensionWithDayOfMonth
extends OlapTimeDimensionWith {
    public static final String NAME = "WithDayOfMonth";

    public OlapTimeDimensionWithDayOfMonth() {
        super(NAME);
    }

    @Override
    int minValue() {
        return 1;
    }

    @Override
    int maxValue() {
        return 31;
    }

    @Override
    protected LocalDateTime apply(LocalDateTime time, OlapNumericEntity[] parameters) {
        int dayOfMonth = this.firstAsInteger(parameters);
        dayOfMonth = Math.min(dayOfMonth, time.dayOfMonth().getMaximumValue());
        return time.withDayOfMonth(dayOfMonth);
    }

    @Override
    protected LocalDate apply(LocalDate time, OlapNumericEntity[] parameters) {
        int dayOfMonth = this.firstAsInteger(parameters);
        dayOfMonth = Math.min(dayOfMonth, time.dayOfMonth().getMaximumValue());
        return time.withDayOfMonth(dayOfMonth);
    }

    @Override
    protected OlapLevelType getLevelChanged() {
        return OlapLevelType.DAY;
    }
}

