/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxTimeNavigationFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class OlapTimeDimensionFunction
extends OlapMdxTimeNavigationFunction {
    protected static final OlapFunctionArgs ARGS_1 = new OlapFunctionArgs(1);
    protected static final OlapFunctionArgs ARGS_2 = new OlapFunctionArgs(2){

        public OlapFunctionArgumentType getType(int pos) {
            return pos < 1 ? super.getType(pos) : OlapFunctionArgumentType.VALUE;
        }
    };
    protected static final OlapFunctionArgs ARGS_3 = new OlapFunctionArgs(3){

        public OlapFunctionArgumentType getType(int pos) {
            return pos < 1 ? super.getType(pos) : OlapFunctionArgumentType.VALUE;
        }
    };
    static final String PREFIX = "dt";

    OlapTimeDimensionFunction(String name, OlapFunctionArgs args) {
        super(PREFIX + name, args);
    }

    OlapTimeDimensionFunction(String name) {
        this(name, ARGS_1);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapMember member;
        OlapEntity arg = args.getNonMissingArgEntity(context, 0, "member|set");
        if (arg.isMdxNull()) {
            return OlapTimeDimensionFunction.asNull();
        }
        OlapMemberFilter memberFilter = args.getSchemaPermissionsWithoutPerspective(context).getDimensionsPermissions(args.getCube(context)).getMemberFilter();
        if (arg.isToMemberApplicable(context.getPrepareContext())) {
            OlapMember member2 = args.toMember(context, 0, true, true);
            return OlapTimeDimensionFunction.asNullable((OlapNonScalarEntity)this.getNavigatedMember(context, args, member2, memberFilter));
        }
        OlapTupleSet set = args.toMemberSet(context, 0, false);
        OlapIterator iter = set.getIterator(false);
        iter.reset();
        ArrayList<OlapMember> newSet = new ArrayList<OlapMember>();
        while ((member = (OlapMember)iter.next()) != null) {
            OlapMember navigatedMember = this.getNavigatedMember(context, args, member, memberFilter);
            if (navigatedMember == null) continue;
            newSet.add(navigatedMember);
        }
        return newSet.isEmpty() ? OlapSetFactory.empty() : OlapSetFactory.instance(newSet);
    }

    @Nullable
    private OlapMember getNavigatedMember(GFContext context, GFFunctionArgs args, @Nullable OlapMember member, @Nullable OlapMemberFilter memberFilter) {
        LocalDate transformedDateTime;
        OlapLevel level;
        block12: {
            if (member == null || member.isMdxNull()) {
                return null;
            }
            if (member.isAll()) {
                return member;
            }
            OlapNumericEntity[] parameters = null;
            if (args.getArgLength() > 1) {
                parameters = new OlapNumericEntity[args.getArgLength()];
                for (int i = 1; i < args.getArgLength(); ++i) {
                    parameters[i] = args.toNumeric(context, i);
                    String error = this.validateParameter(i, parameters[i]);
                    if (error == null) continue;
                    throw new OlapFunctionEvaluationException(args.getErrorContext(context, i), this.getName(), OlapErrorCode.FUNCTION_ARGUMENT_ERROR, new Serializable[]{Integer.valueOf(i), error});
                }
            }
            level = member.getLevel();
            OlapLevelType levelType = level.getLevelType();
            Object[] keyType = level.getMemberKeyType();
            if (!(keyType == null || keyType.length == 1 && keyType[0].isDateType())) {
                return (OlapMember)args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_KEYTYPE_EXPECTED, new Serializable[]{level.getUniqueName(OlapNameContext.DEFAULT_VALUES), Arrays.toString(keyType)});
            }
            OlapLevelType levelChanged = this.getLevelChanged();
            if (levelType != null && levelChanged != null && levelType.isBefore(levelChanged)) {
                return (OlapMember)args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_EXPECTED_LEVEL_TYPE, new Serializable[]{level.getUniqueName(OlapNameContext.DEFAULT_VALUES), levelChanged.toString(), Arrays.toString(keyType)});
            }
            try {
                Comparable dateTime = member.getKeyValue();
                if (dateTime instanceof LocalDate) {
                    LocalDate date = (LocalDate)dateTime;
                    LocalDate t = this.apply(date, parameters);
                    if (level.getLevelType() == OlapLevelType.WEEK) {
                        t = t.withDayOfWeek(1);
                    }
                    transformedDateTime = t;
                    break block12;
                }
                if (dateTime instanceof LocalDateTime) {
                    LocalDateTime time = (LocalDateTime)dateTime;
                    LocalDateTime t = this.apply(time, parameters);
                    if (level.getLevelType() == OlapLevelType.WEEK) {
                        t = t.withDayOfWeek(1);
                    }
                    transformedDateTime = t;
                    break block12;
                }
                return (OlapMember)args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_KEYTYPE_EXPECTED, new Serializable[]{level.getUniqueName(OlapNameContext.DEFAULT_VALUES), dateTime.getClass().getSimpleName()});
            }
            catch (IllegalArgumentException ex) {
                throw new OlapFunctionEvaluationException(args.getErrorContext(context, 1), this.getName(), OlapErrorCode.FUNCTION_ARGUMENT_ERROR, new Serializable[]{Integer.valueOf(1), ex.toString()});
            }
        }
        OlapMember retMember = level.lookupMemberByKeyValue((Object)transformedDateTime);
        return retMember == null || memberFilter != null && !memberFilter.isAccepting(retMember) ? null : retMember;
    }

    @Nullable
    protected String validateParameter(int i, OlapNumericEntity parameter) {
        return null;
    }

    int firstAsInteger(OlapNumericEntity[] parameters) {
        return (int)parameters[1].value();
    }

    int secAsInteger(OlapNumericEntity[] parameters) {
        return (int)parameters[2].value();
    }

    protected abstract LocalDateTime apply(LocalDateTime var1, OlapNumericEntity[] var2);

    protected abstract LocalDate apply(LocalDate var1, OlapNumericEntity[] var2);

    @Nullable
    protected abstract OlapLevelType getLevelChanged();
}

