/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxTimeNavigationFunction;
import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

abstract class OlapTimeDimensionAsOfBase
extends OlapMdxTimeNavigationFunction {
    OlapTimeDimensionAsOfBase(String name, OlapFunctionArgs args) {
        super(name, args);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        boolean isDateType;
        OlapLevel level;
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "hierarchy|level");
        if (arg0.isMdxNull()) {
            return OlapTimeDimensionAsOfBase.asNull();
        }
        if (arg0 instanceof OlapLevel) {
            level = (OlapLevel)arg0;
        } else if (arg0 instanceof OlapDimension) {
            level = args.toOnlyHierarchy(context, 0, (OlapDimension)arg0).getLastLevel();
        } else if (arg0 instanceof OlapHierarchy) {
            level = ((OlapHierarchy)arg0).getLastLevel();
        } else {
            return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "hierarchy|dimension|level", arg0.getFriendlyTypeName());
        }
        if (level.isKeyType(LocalDate.class)) {
            isDateType = true;
        } else if (level.isKeyType(LocalDateTime.class)) {
            isDateType = false;
        } else {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_KEYTYPE_EXPECTED, new Serializable[]{level.getUniqueName(OlapNameContext.DEFAULT_VALUES), Arrays.toString(level.getMemberKeyType())});
        }
        Object transformedDateTime = this.getLookupKey(context, args, isDateType);
        if (transformedDateTime == null) {
            return OlapTimeDimensionAsOfBase.asNull();
        }
        OlapMember retMember = level.lookupMemberByKeyValue(transformedDateTime);
        OlapLevelType levelType = level.getLevelType();
        if (retMember == null && levelType != null) {
            if (transformedDateTime instanceof LocalDateTime) {
                LocalDateTime dateTime = (LocalDateTime)transformedDateTime;
                LocalDateTime t = levelType.transformToValidDate(dateTime, context.getLocale());
                retMember = level.lookupMemberByKeyValue((Object)t);
            } else if (transformedDateTime instanceof LocalDate) {
                LocalDate dateTime = (LocalDate)transformedDateTime;
                LocalDateTime t = levelType.transformToValidDate(dateTime.toLocalDateTime(new LocalTime(0L)), context.getLocale());
                retMember = level.lookupMemberByKeyValue((Object)t.toLocalDate());
            }
        }
        OlapMemberFilter memberFilter = args.getSchemaPermissionsWithoutPerspective(context).getDimensionsPermissions(args.getCube(context)).getMemberFilter();
        return retMember == null || memberFilter != null && !memberFilter.isAccepting(retMember) ? OlapTimeDimensionAsOfBase.asNull() : retMember;
    }

    @Nullable
    abstract Object getLookupKey(GFContext var1, GFFunctionArgs var2, boolean var3);
}

