/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.plugin.olapfunctions.timedimension.OlapDatesTimeDimensionFunction;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapDatesWorkweekTimeDimensionFunction
extends OlapDatesTimeDimensionFunction {
    public static final String NAME = "DatesWorkWeek";

    public OlapDatesWorkweekTimeDimensionFunction() {
        super(NAME);
    }

    @Override
    @Nullable
    protected OlapMember getEndPeriodMember(OlapMember member) {
        return this.getLastExistingWeekday(member, 1, 5);
    }

    @Override
    protected Predicate<OlapMember> filter(LocalDateTime time) {
        int week = time.getWeekOfWeekyear();
        return member -> ((LocalDateTime)member.getKeyValue()).getWeekOfWeekyear() == week;
    }

    @Override
    protected Predicate<OlapMember> filter(LocalDate time) {
        int week = time.getWeekOfWeekyear();
        return member -> ((LocalDate)member.getKeyValue()).getWeekOfWeekyear() == week;
    }

    @Override
    protected boolean compactDefaultValue() {
        return false;
    }

    @Override
    protected boolean errorOnLevelMismatch() {
        return true;
    }
}

